/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;

public class ResourceDependencyProvider
implements IResourceDependencyProvider {
    private final IGraph<URI> dependencyGraph;

    public ResourceDependencyProvider(IResolutionContext context) {
        Preconditions.checkNotNull((Object)context);
        this.dependencyGraph = (IGraph)Preconditions.checkNotNull(context.getGraph());
    }

    @Override
    public Iterable<URI> getDependenciesOf(IFile file) {
        return this.getDependenciesOf(file, Collections.emptySet());
    }

    @Override
    public boolean hasChild(URI parent, URI candidate) {
        return this.dependencyGraph.hasChild((Object)parent, (Object)candidate);
    }

    @Override
    public Iterable<URI> getDependenciesOf(IFile file, Set<URI> bounds) {
        Iterable dependencies;
        URI expectedURI = ResourceUtil.createURIFor((IFile)file);
        switch (ResolutionUtil.getResolutionScope()) {
            case WORKSPACE: {
                dependencies = this.dependencyGraph.getSubgraphContaining((Object)expectedURI, bounds);
                break;
            }
            case PROJECT: {
                Set allDependencies = this.dependencyGraph.getSubgraphContaining((Object)expectedURI, bounds);
                IProject project = file.getProject();
                dependencies = Iterables.filter((Iterable)allDependencies, this.isInContainer((IResource)project));
                break;
            }
            case CONTAINER: {
                Set allDependencies1 = this.dependencyGraph.getSubgraphContaining((Object)expectedURI, bounds);
                IContainer container = file.getParent();
                dependencies = Iterables.filter((Iterable)allDependencies1, this.isInContainer((IResource)container));
                break;
            }
            case OUTGOING: {
                dependencies = this.dependencyGraph.getTreeFrom((Object)expectedURI, bounds);
                break;
            }
            default: {
                dependencies = Collections.singleton(expectedURI);
            }
        }
        return dependencies;
    }

    protected Predicate<URI> isInContainer(final IResource container) {
        return new Predicate<URI>(){

            public boolean apply(URI input) {
                IFile pointedFile;
                if (input != null && (pointedFile = ResolutionUtil.getFileAt(input)) != null && pointedFile.getLocation() != null) {
                    return container.getLocation().isPrefixOf(pointedFile.getLocation());
                }
                return false;
            }
        };
    }
}

