/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class AutosizeTrigger
implements ModelChangeTrigger {
    public static final Adapter AUTO_SIZE_MARKER = new AdapterImpl();
    private TransactionalEditingDomain domain;
    public static final NotificationFilter IS_GMF_NODE_ATTACHMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            EReference ref;
            Object object;
            return input.getNewValue() instanceof Node && (object = input.getFeature()) instanceof EReference && (ref = (EReference)object).isContainment();
        }
    };

    public AutosizeTrigger(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final Collection<Node> toMakeAutosize = this.collectElementsToAutoSize(notifications);
        if (!toMakeAutosize.isEmpty()) {
            RecordingCommand result = new RecordingCommand(this.domain){

                protected void doExecute() {
                    for (Node node : toMakeAutosize) {
                        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
                        if (!(layoutConstraint instanceof Bounds)) continue;
                        Bounds bounds = (Bounds)layoutConstraint;
                        bounds.setWidth(-1);
                        bounds.setHeight(-1);
                    }
                }
            };
            return Options.newSome((Object)result);
        }
        return Options.newNone();
    }

    private Collection<Node> collectElementsToAutoSize(Collection<Notification> notifications) {
        LinkedHashSet<Node> toMakeAutosize = new LinkedHashSet<Node>();
        block0: for (Notification notif : notifications) {
            DSemanticDecorator semanticDecorator;
            EObject semanticObject;
            Node nd = (Node)notif.getNewValue();
            EObject eObject = nd.getElement();
            if (!(eObject instanceof DSemanticDecorator) || (semanticObject = (semanticDecorator = (DSemanticDecorator)eObject).getTarget()) == null) continue;
            Iterator iter = semanticObject.eAdapters().iterator();
            while (iter.hasNext()) {
                Adapter adapter = (Adapter)iter.next();
                if (adapter != AUTO_SIZE_MARKER) continue;
                iter.remove();
                toMakeAutosize.add(nd);
                continue block0;
            }
        }
        return toMakeAutosize;
    }

    public int priority() {
        return 0;
    }
}

