/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.util.Strings;

public class MapBasedScope
extends AbstractScope {
    private Map<QualifiedName, ? extends EObject> entries;

    public MapBasedScope(Map<QualifiedName, ? extends EObject> entries) {
        super(IScope.NULLSCOPE, false);
        this.entries = entries;
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return Iterables.transform(this.entries.entrySet(), (Function)new Function<Map.Entry<QualifiedName, ? extends EObject>, IEObjectDescription>(){

            public IEObjectDescription apply(Map.Entry<QualifiedName, ? extends EObject> from) {
                return new MapEntry(from);
            }
        });
    }

    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        EObject element = this.entries.get(name);
        if (element != null) {
            return Collections.singleton(EObjectDescription.create((QualifiedName)name, (EObject)element));
        }
        return Collections.emptySet();
    }

    public static class MapEntry
    implements IEObjectDescription {
        private final Map.Entry<QualifiedName, ? extends EObject> entry;

        public MapEntry(Map.Entry<QualifiedName, ? extends EObject> entry) {
            this.entry = entry;
        }

        public QualifiedName getName() {
            return this.entry.getKey();
        }

        public QualifiedName getQualifiedName() {
            return this.entry.getKey();
        }

        public EObject getEObjectOrProxy() {
            return this.entry.getValue();
        }

        public URI getEObjectURI() {
            return EcoreUtil.getURI((EObject)this.entry.getValue());
        }

        public EClass getEClass() {
            return this.entry.getValue().eClass();
        }

        public String getUserData(String name) {
            return null;
        }

        public String[] getUserDataKeys() {
            return Strings.EMPTY_ARRAY;
        }
    }
}

