/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.runtime.ui;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URL;
import java.util.Map;
import org.eclipse.emf.parsley.runtime.ui.AbstractImageHelper;
import org.eclipse.emf.parsley.runtime.ui.IImageHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

@Singleton
public class PluginImageHelper
extends AbstractImageHelper
implements IImageHelper,
SynchronousBundleListener {
    private Map<ImageDescriptor, Image> registry = Maps.newHashMapWithExpectedSize((int)10);
    @Inject
    private AbstractUIPlugin plugin;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.PluginImageHelper.pathSuffix")
    private String pathSuffix = "icons/";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.PluginImageHelper.defaultImage")
    private String defaultImage = "default.gif";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.PluginImageHelper.notFound")
    private String notFound = "notFound.gif";

    @Override
    public Image getImage(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.registry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.registry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.registry.values()) {
            image.dispose();
        }
        this.registry.clear();
    }

    @Inject
    public void hookBundleListener(AbstractUIPlugin plugin) {
        plugin.getBundle().getBundleContext().addBundleListener((BundleListener)this);
    }

    @Override
    public Image getImage(String imageName) {
        String imgname;
        String string = imgname = imageName == null ? this.defaultImage : imageName;
        if (imgname != null) {
            Image result = null;
            URL imgUrl = this.getPlugin().getBundle().getEntry(this.getPathSuffix() + imgname);
            if (imgUrl != null) {
                ImageDescriptor id = null;
                result = this.getPlugin().getImageRegistry().get(imgUrl.toExternalForm());
                if (result == null && (id = ImageDescriptor.createFromURL((URL)imgUrl)) != null) {
                    result = id.createImage();
                    this.getPlugin().getImageRegistry().put(imgUrl.toExternalForm(), result);
                }
                return result;
            }
            if (!imgname.equals(this.notFound)) {
                return this.getImage(this.notFound);
            }
        }
        return null;
    }

    public void setPathSuffix(String pathSuffix) {
        this.pathSuffix = pathSuffix;
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    public void setPlugin(AbstractUIPlugin plugin) {
        this.plugin = plugin;
    }

    public AbstractUIPlugin getPlugin() {
        return this.plugin;
    }

    public void setNotFound(String notFound) {
        this.notFound = notFound;
    }

    public String getNotFound() {
        return this.notFound;
    }

    public String getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(String defaultImage) {
        this.defaultImage = defaultImage;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 256 && event.getBundle().getBundleId() == this.getPlugin().getBundle().getBundleId()) {
            this.dispose();
        }
    }
}

