/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.activate;

import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import org.eclipse.gef.common.activate.IActivatable;

public class ActivatableSupport {
    private ReadOnlyBooleanWrapper activeProperty = null;

    public ActivatableSupport(IActivatable source) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null.");
        }
        this.activeProperty = new ReadOnlyBooleanWrapper((Object)source, "active", false);
    }

    public void activate(Runnable preActivationCallback, Runnable postActivationCallback) {
        if (!this.isActive()) {
            if (preActivationCallback != null) {
                preActivationCallback.run();
            }
            this.activeProperty.set(true);
            if (postActivationCallback != null) {
                postActivationCallback.run();
            }
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.activeProperty.getReadOnlyProperty();
    }

    public void deactivate(Runnable preDeactivationCallback, Runnable postDeactivationCallback) {
        if (this.isActive()) {
            if (preDeactivationCallback != null) {
                preDeactivationCallback.run();
            }
            this.activeProperty.set(false);
            if (postDeactivationCallback != null) {
                postDeactivationCallback.run();
            }
        }
    }

    public boolean isActive() {
        return this.activeProperty.get();
    }
}

