/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javafx.beans.InvalidationListener;
import org.eclipse.gef.common.collections.MultisetChangeListener;
import org.eclipse.gef.common.collections.MultisetListenerHelper;
import org.eclipse.gef.common.collections.ObservableMultiset;

class ObservableMultisetWrapper<E>
extends ForwardingMultiset<E>
implements ObservableMultiset<E> {
    private MultisetListenerHelper<E> helper = new MultisetListenerHelper(this);
    private Multiset<E> backingMultiset;

    public ObservableMultisetWrapper(Multiset<E> setMultimap) {
        this.backingMultiset = setMultimap;
    }

    public boolean add(E element) {
        Multiset<E> previousContents = this.delegateCopy();
        boolean changed = super.add(element);
        if (changed) {
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<E>(element, 0, 1)));
        }
        return changed;
    }

    public int add(E element, int occurrences) {
        Multiset<E> previousContents = this.delegateCopy();
        int countBefore = super.add(element, occurrences);
        if (this.count(element) > countBefore) {
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<E>(element, 0, this.count(element) - countBefore)));
        }
        return countBefore;
    }

    public boolean addAll(Collection<? extends E> collection) {
        Multiset<E> previousContents = this.delegateCopy();
        boolean changed = super.addAll(collection);
        if (changed) {
            ArrayList<MultisetListenerHelper.ElementarySubChange<MultisetListenerHelper.ElementarySubChange<E>>> elementaryChanges = new ArrayList<MultisetListenerHelper.ElementarySubChange<MultisetListenerHelper.ElementarySubChange<E>>>();
            for (E e : new HashSet<E>(collection)) {
                if (previousContents.contains(e)) {
                    if (this.count(e) <= previousContents.count(e)) continue;
                    elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange<E>(e, 0, this.count(e) - previousContents.count(e)));
                    continue;
                }
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange<E>(e, 0, this.count(e)));
            }
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, elementaryChanges));
        }
        return changed;
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    @Override
    public void addListener(MultisetChangeListener<? super E> listener) {
        this.helper.addListener(listener);
    }

    public void clear() {
        Multiset<E> previousContents = this.delegateCopy();
        super.clear();
        if (!previousContents.isEmpty()) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : previousContents.elementSet()) {
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, previousContents.count(e), 0));
            }
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, elementaryChanges));
        }
    }

    protected Multiset<E> delegate() {
        return this.backingMultiset;
    }

    protected Multiset<E> delegateCopy() {
        return HashMultiset.create(this.backingMultiset);
    }

    public boolean remove(Object object) {
        Multiset<E> previousContents = this.delegateCopy();
        boolean changed = super.remove(object);
        if (changed) {
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<Object>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<Object>(object, 1, 0)));
        }
        return changed;
    }

    public int remove(Object element, int occurrences) {
        Multiset<E> previousContents = this.delegateCopy();
        int countBefore = super.remove(element, occurrences);
        if (countBefore > this.count(element)) {
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<Object>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<Object>(element, countBefore - this.count(element), 0)));
        }
        return countBefore;
    }

    public boolean removeAll(Collection<?> collection) {
        Multiset<E> previousContents = this.delegateCopy();
        boolean changed = super.removeAll(collection);
        if (changed) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : new HashSet(collection)) {
                if (!previousContents.contains(e) || previousContents.count(e) <= this.count(e)) continue;
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, previousContents.count(e), 0));
            }
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, elementaryChanges));
        }
        return changed;
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    @Override
    public void removeListener(MultisetChangeListener<? super E> listener) {
        this.helper.removeListener(listener);
    }

    @Override
    public boolean replaceAll(Multiset<? extends E> multiset) {
        Multiset<E> previousContents = this.delegateCopy();
        super.clear();
        super.addAll(multiset);
        Multiset removedElements = Multisets.difference(previousContents, multiset);
        Multiset addedElements = Multisets.difference(multiset, previousContents);
        if (!addedElements.isEmpty() || !removedElements.isEmpty()) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : removedElements.elementSet()) {
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, removedElements.count(e), 0));
            }
            for (Object e : addedElements.elementSet()) {
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, 0, addedElements.count(e)));
            }
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, elementaryChanges));
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection<?> collection) {
        Multiset<E> previousContents = this.delegateCopy();
        boolean changed = super.retainAll(collection);
        if (changed) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : previousContents.elementSet()) {
                if (collection.contains(e)) continue;
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, previousContents.count(e), 0));
            }
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, elementaryChanges));
        }
        return changed;
    }

    public int setCount(E element, int count) {
        Multiset<E> previousContents = this.delegateCopy();
        int countBefore = super.setCount(element, count);
        if (this.count(element) > countBefore) {
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<E>(element, 0, this.count(element) - countBefore)));
        } else if (this.count(element) < countBefore) {
            this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<E>(element, countBefore - this.count(element), 0)));
        }
        return countBefore;
    }

    public boolean setCount(E element, int oldCount, int newCount) {
        Multiset<E> previousContents = this.delegateCopy();
        boolean changed = super.setCount(element, oldCount, newCount);
        if (changed) {
            if (newCount > oldCount) {
                this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<E>(element, 0, newCount - oldCount)));
            } else if (oldCount > newCount) {
                this.helper.fireValueChangedEvent(new MultisetListenerHelper.AtomicChange<E>(this, previousContents, new MultisetListenerHelper.ElementarySubChange<E>(element, oldCount - newCount, 0)));
            }
        }
        return changed;
    }
}

