/*
 * generated by Xtext 2.32.0
 */
package org.eclipse.gef.dot.internal.language.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class DotColorListGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class ColorListElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.gef.dot.internal.language.DotColorList.ColorList");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cColorValuesAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cColorValuesWCParserRuleCall_0_0 = (RuleCall)cColorValuesAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cColorValuesAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cColorValuesWCParserRuleCall_1_1_0 = (RuleCall)cColorValuesAssignment_1_1.eContents().get(0);
		
		///*
		// * A colon-separated list of weighted color values: WC(:WC)* where each WC has the form C(;F)?
		// * with C a color value and the optional F a floating-point number, 0 ≤ F ≤ 1. The sum of the
		// * floating-point numbers in a colorList must sum to at most 1.
		// */
		//ColorList:
		//    colorValues+=WC(':' colorValues+=WC)*;
		@Override public ParserRule getRule() { return rule; }
		
		//colorValues+=WC(':' colorValues+=WC)*
		public Group getGroup() { return cGroup; }
		
		//colorValues+=WC
		public Assignment getColorValuesAssignment_0() { return cColorValuesAssignment_0; }
		
		//WC
		public RuleCall getColorValuesWCParserRuleCall_0_0() { return cColorValuesWCParserRuleCall_0_0; }
		
		//(':' colorValues+=WC)*
		public Group getGroup_1() { return cGroup_1; }
		
		//':'
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }
		
		//colorValues+=WC
		public Assignment getColorValuesAssignment_1_1() { return cColorValuesAssignment_1_1; }
		
		//WC
		public RuleCall getColorValuesWCParserRuleCall_1_1_0() { return cColorValuesWCParserRuleCall_1_1_0; }
	}
	public class WCElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.gef.dot.internal.language.DotColorList.WC");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cColorAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cColorColorParserRuleCall_0_0 = (RuleCall)cColorAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cSemicolonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cWeightAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cWeightCOLOR_NUMBERTerminalRuleCall_1_1_0 = (RuleCall)cWeightAssignment_1_1.eContents().get(0);
		
		//WC:
		//    color=Color(';' weight=COLOR_NUMBER)?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//color=Color(';' weight=COLOR_NUMBER)?
		public Group getGroup() { return cGroup; }
		
		//color=Color
		public Assignment getColorAssignment_0() { return cColorAssignment_0; }
		
		//Color
		public RuleCall getColorColorParserRuleCall_0_0() { return cColorColorParserRuleCall_0_0; }
		
		//(';' weight=COLOR_NUMBER)?
		public Group getGroup_1() { return cGroup_1; }
		
		//';'
		public Keyword getSemicolonKeyword_1_0() { return cSemicolonKeyword_1_0; }
		
		//weight=COLOR_NUMBER
		public Assignment getWeightAssignment_1_1() { return cWeightAssignment_1_1; }
		
		//COLOR_NUMBER
		public RuleCall getWeightCOLOR_NUMBERTerminalRuleCall_1_1_0() { return cWeightCOLOR_NUMBERTerminalRuleCall_1_1_0; }
	}
	
	
	private final ColorListElements pColorList;
	private final WCElements pWC;
	
	private final Grammar grammar;
	
	private final DotColorGrammarAccess gaDotColor;

	@Inject
	public DotColorListGrammarAccess(GrammarProvider grammarProvider,
			DotColorGrammarAccess gaDotColor) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaDotColor = gaDotColor;
		this.pColorList = new ColorListElements();
		this.pWC = new WCElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.gef.dot.internal.language.DotColorList".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public DotColorGrammarAccess getDotColorGrammarAccess() {
		return gaDotColor;
	}

	
	///*
	// * A colon-separated list of weighted color values: WC(:WC)* where each WC has the form C(;F)?
	// * with C a color value and the optional F a floating-point number, 0 ≤ F ≤ 1. The sum of the
	// * floating-point numbers in a colorList must sum to at most 1.
	// */
	//ColorList:
	//    colorValues+=WC(':' colorValues+=WC)*;
	public ColorListElements getColorListAccess() {
		return pColorList;
	}
	
	public ParserRule getColorListRule() {
		return getColorListAccess().getRule();
	}
	
	//WC:
	//    color=Color(';' weight=COLOR_NUMBER)?
	//;
	public WCElements getWCAccess() {
		return pWC;
	}
	
	public ParserRule getWCRule() {
		return getWCAccess().getRule();
	}
	
	///*
	// * This grammar comes with a custom lexer to disable the COLOR_NUMBER and the COLOR_STRING terminal rules
	// * within the context of an RGBColor definition (when the color is defined starting with a '#' symbol)
	// * to be able to parse the hex values (such as '#000000' and '#ffffff') properly.
	// */
	//// XXX: While not documented explicitly, an empty color seems to be valid as well (see bug #520919)
	//Color:
	//    (RGBColor | HSVColor | StringColor)?
	//;
	public DotColorGrammarAccess.ColorElements getColorAccess() {
		return gaDotColor.getColorAccess();
	}
	
	public ParserRule getColorRule() {
		return getColorAccess().getRule();
	}
	
	//RGBColor:
	//    '#' r=hex g=hex b=hex (a=hex)?
	//;
	public DotColorGrammarAccess.RGBColorElements getRGBColorAccess() {
		return gaDotColor.getRGBColorAccess();
	}
	
	public ParserRule getRGBColorRule() {
		return getRGBColorAccess().getRule();
	}
	
	//HSVColor:
	//    h=COLOR_NUMBER ','? s=COLOR_NUMBER ','? v=COLOR_NUMBER
	//;
	public DotColorGrammarAccess.HSVColorElements getHSVColorAccess() {
		return gaDotColor.getHSVColorAccess();
	}
	
	public ParserRule getHSVColorRule() {
		return getHSVColorAccess().getRule();
	}
	
	//StringColor:
	//    ("/" (scheme=COLOR_STRING)? "/")?
	//    name=(HEXADECIMAL_DIGIT | COLOR_STRING | COLOR_NUMBER)
	//;
	public DotColorGrammarAccess.StringColorElements getStringColorAccess() {
		return gaDotColor.getStringColorAccess();
	}
	
	public ParserRule getStringColorRule() {
		return getStringColorAccess().getRule();
	}
	
	//hex:
	//    HEXADECIMAL_DIGIT HEXADECIMAL_DIGIT
	//;
	public DotColorGrammarAccess.HexElements getHexAccess() {
		return gaDotColor.getHexAccess();
	}
	
	public ParserRule getHexRule() {
		return getHexAccess().getRule();
	}
	
	//terminal COLOR_NUMBER:
	//    ('.' DIGITS+) | ZERO_OR_ONE ('.' (DIGITS)+)?
	//;
	public TerminalRule getCOLOR_NUMBERRule() {
		return gaDotColor.getCOLOR_NUMBERRule();
	}
	
	//terminal HEXADECIMAL_DIGIT:
	//    DIGITS | 'a' .. 'f' | 'A' .. 'F'
	//;
	public TerminalRule getHEXADECIMAL_DIGITRule() {
		return gaDotColor.getHEXADECIMAL_DIGITRule();
	}
	
	//terminal COLOR_STRING:
	//    ('a'..'z' | 'A'..'Z' | DIGITS)+
	//;
	public TerminalRule getCOLOR_STRINGRule() {
		return gaDotColor.getCOLOR_STRINGRule();
	}
	
	//terminal fragment ZERO_OR_ONE:
	//    '0'|'1'
	//;
	public TerminalRule getZERO_OR_ONERule() {
		return gaDotColor.getZERO_OR_ONERule();
	}
	
	//terminal fragment DIGITS:
	//    ZERO_OR_ONE | '2'..'9'
	//;
	public TerminalRule getDIGITSRule() {
		return gaDotColor.getDIGITSRule();
	}
	
	//terminal WS:
	//    (' ' | '\t' | '\r' | '\n')+;
	public TerminalRule getWSRule() {
		return gaDotColor.getWSRule();
	}
}
