/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.quickfix;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

class DotHtmlLabelQuickfixDelegator {
    private Injector injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");

    public void provideQuickfixes(Issue originalIssue, Issue subgrammarIssue, IssueResolutionAcceptor acceptor) {
        List<IssueResolution> resolutions = this.getResolutions(subgrammarIssue);
        for (final IssueResolution issueResolution : resolutions) {
            acceptor.accept(originalIssue, issueResolution.getLabel(), issueResolution.getDescription(), issueResolution.getImage(), new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    Attribute attribute = (Attribute)element;
                    String originalText = attribute.getValue().toValue();
                    String modifiedText = DotHtmlLabelQuickfixDelegator.this.getModifiedText(originalText, issueResolution);
                    attribute.setValue(ID.fromValue((String)modifiedText, (ID.Type)ID.Type.HTML_STRING));
                }
            });
        }
    }

    private List<IssueResolution> getResolutions(Issue issue) {
        IssueResolutionProvider quickfixProvider = (IssueResolutionProvider)this.injector.getInstance(IssueResolutionProvider.class);
        return quickfixProvider.getResolutions(issue);
    }

    private String getModifiedText(String originalText, IssueResolution issueResolution) {
        final IXtextDocument document = this.getDocument(originalText);
        IModificationContext modificationContext = new IModificationContext(){

            public IXtextDocument getXtextDocument() {
                return document;
            }

            public IXtextDocument getXtextDocument(URI uri) {
                return document;
            }
        };
        new IssueResolution(issueResolution.getLabel(), issueResolution.getDescription(), issueResolution.getImage(), modificationContext, issueResolution.getModification(), issueResolution.getRelevance()).apply();
        return document.get();
    }

    private IXtextDocument getDocument(String model) {
        XtextResource xtextResource = this.getXtextResource(model);
        XtextDocument document = (XtextDocument)this.injector.getInstance(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        return document;
    }

    private XtextResource getXtextResource(String model) {
        StringInputStream in = new StringInputStream(Strings.emptyIfNull((String)model));
        URI uri = URI.createURI((String)"");
        Resource resource = ((IResourceFactory)this.injector.getInstance(IResourceFactory.class)).createResource(uri);
        new XtextResourceSet().getResources().add((Object)resource);
        try {
            resource.load((InputStream)in, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return (XtextResource)resource;
    }
}

