/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.mm.algorithms.styles;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LocationType implements Enumerator
{
    LOCATION_TYPE_RELATIVE(1, "LOCATION_TYPE_RELATIVE", "LOCATION_TYPE_RELATIVE"),
    LOCATION_TYPE_ABSOLUTE_START(2, "LOCATION_TYPE_ABSOLUTE_START", "LOCATION_TYPE_ABSOLUTE_START"),
    LOCATION_TYPE_ABSOLUTE_END(3, "LOCATION_TYPE_ABSOLUTE_END", "LOCATION_TYPE_ABSOLUTE_END");

    public static final int LOCATION_TYPE_RELATIVE_VALUE = 1;
    public static final int LOCATION_TYPE_ABSOLUTE_START_VALUE = 2;
    public static final int LOCATION_TYPE_ABSOLUTE_END_VALUE = 3;
    private static final LocationType[] VALUES_ARRAY;
    public static final List<LocationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LocationType[]{LOCATION_TYPE_RELATIVE, LOCATION_TYPE_ABSOLUTE_START, LOCATION_TYPE_ABSOLUTE_END};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LocationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LocationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LocationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LocationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LocationType get(int value) {
        switch (value) {
            case 1: {
                return LOCATION_TYPE_RELATIVE;
            }
            case 2: {
                return LOCATION_TYPE_ABSOLUTE_START;
            }
            case 3: {
                return LOCATION_TYPE_ABSOLUTE_END;
            }
        }
        return null;
    }

    private LocationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

