/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.datatypes.impl;

import org.eclipse.graphiti.datatypes.IAdvancedDimension;
import org.eclipse.graphiti.datatypes.IAdvancedLocation;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.datatypes.IRectangle;
import org.eclipse.graphiti.internal.datatypes.impl.DimensionImpl;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;

public class RectangleImpl
implements IRectangle {
    private IAdvancedDimension dimension = new DimensionImpl(0, 0);
    private IAdvancedLocation location = new LocationImpl(0, 0);

    public RectangleImpl(int width, int height) {
        this(0, 0, width, height);
    }

    public RectangleImpl(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public RectangleImpl(IRectangle other) {
        this(other.getX(), other.getY(), other.getWidth(), other.getHeight());
    }

    @Override
    public int getHeight() {
        return this.getDimension().getHeight();
    }

    @Override
    public int getWidth() {
        return this.getDimension().getWidth();
    }

    @Override
    public void setHeight(int height) {
        this.getDimension().setHeight(height);
    }

    @Override
    public void setWidth(int width) {
        this.getDimension().setWidth(width);
    }

    @Override
    public int getX() {
        return this.getLocation().getX();
    }

    @Override
    public int getY() {
        return this.getLocation().getY();
    }

    @Override
    public void setX(int x) {
        this.getLocation().setX(x);
    }

    @Override
    public void setY(int y) {
        this.getLocation().setY(y);
    }

    private IAdvancedDimension getDimension() {
        return this.dimension;
    }

    private IAdvancedLocation getLocation() {
        return this.location;
    }

    public int hashCode() {
        return (this.getX() + this.getHeight() + 1) * (this.getY() + this.getWidth() + 1) ^ this.getX() ^ this.getY();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RectangleImpl) {
            RectangleImpl r = (RectangleImpl)o;
            return this.getX() == r.getX() && this.getY() == r.getY() && this.getWidth() == r.getWidth() && this.getHeight() == r.getHeight();
        }
        return false;
    }

    public String toString() {
        return "Rectangle(" + this.getX() + ", " + this.getY() + ", " + this.getWidth() + ", " + this.getHeight() + ")";
    }

    public IDimension expand(int dw, int dh) {
        return this.getDimension().expand(dw, dh);
    }

    public IDimension getDimensionCopy() {
        return this.getDimension().getDimensionCopy();
    }

    public void scale(double amount) {
        this.getDimension().scale(amount);
        this.getLocation().scale(amount);
    }

    public IDimension setDimension(int width, int height) {
        return this.getDimension().setDimension(width, height);
    }

    public IDimension setDimension(IDimension dimension) {
        return this.getDimension().setDimension(dimension);
    }

    public ILocation getLocationCopy() {
        return this.getLocation().getLocationCopy();
    }

    public ILocation setLocation(int x, int y) {
        return this.getLocation().setLocation(x, y);
    }

    public ILocation setLocation(ILocation location) {
        return this.getLocation().setLocation(location);
    }

    public ILocation translate(int dx, int dy) {
        return this.getLocation().translate(dx, dy);
    }

    @Override
    public IRectangle getRectangleCopy() {
        return new RectangleImpl(this);
    }

    @Override
    public void setRectangle(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public void setRectangle(IRectangle rectangle) {
        this.setRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    @Override
    public boolean contains(int x, int y) {
        return y >= this.getY() && y < this.getY() + this.getHeight() && x >= this.getX() && x < this.getX() + this.getWidth();
    }

    @Override
    public boolean contains(ILocation location) {
        return this.contains(location.getX(), location.getY());
    }
}

