/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceWriter {
    private final StringBuilder buf;
    private final Locale locale;
    private final boolean isXML;

    public PreferenceWriter(StringBuilder buf, Locale locale) {
        this(buf, locale, false);
    }

    public PreferenceWriter(StringBuilder buf, Locale locale, boolean isXML) {
        this.buf = buf;
        this.locale = locale;
        this.isXML = isXML;
    }

    public void writePreferences() {
        this.writePreference("org.eclipse.help");
        this.writePreference("org.eclipse.help.base");
    }

    private void writePreference(String plugin) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(plugin);
            HashSet<String> keySet = new HashSet<String>();
            prefs = DefaultScope.INSTANCE.getNode(plugin);
            keySet.addAll(Arrays.asList(prefs.keys()));
            Object[] allKeys = keySet.toArray(new String[keySet.size()]);
            if (allKeys.length > 0) {
                Arrays.sort(allKeys);
                if (!this.isXML) {
                    this.buf.append("\n<h3>");
                    this.buf.append(plugin);
                    this.buf.append("</h3>\n");
                    this.buf.append("<table>");
                } else {
                    this.buf.append("\n    <plugin\n          title=\"");
                    this.buf.append(XMLGenerator.xmlEscape(plugin));
                    this.buf.append("\">");
                }
                Object[] objectArray = allKeys;
                int n = allKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    String value = Platform.getPreferencesService().getString(plugin, (String)key, "", null);
                    if (!this.isXML) {
                        this.buf.append("\n    <tr>\n");
                        this.buf.append("        <td>");
                        this.buf.append(UrlUtil.htmlEncode((String)key));
                        this.buf.append("</td>\n        <td>");
                        this.buf.append(UrlUtil.htmlEncode(value));
                        this.buf.append("</td>\n    </tr>");
                    } else {
                        this.buf.append("\n        <");
                        this.buf.append((String)key);
                        this.buf.append(">");
                        this.buf.append(value);
                        this.buf.append("</");
                        this.buf.append((String)key);
                        this.buf.append(">");
                    }
                    ++n2;
                }
                if (!this.isXML) {
                    this.buf.append("\n</table>");
                } else {
                    this.buf.append("\n    </plugin>");
                }
            }
        }
        catch (BackingStoreException e) {
            this.buf.append(WebappResources.getString("badPreferences", this.locale));
        }
    }
}

