/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitorThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.ThreadMonitorManager;

public class JavaMonitor {
    private final IJavaObject fMonitor;
    private JavaMonitorThread fOwningThread;
    private JavaMonitorThread[] fWaitingThreads = new JavaMonitorThread[0];
    private boolean fIsInDeadlock;
    private boolean fToUpdate = true;
    private final List<PlatformObject> fElements = new ArrayList<PlatformObject>();

    public JavaMonitor(IJavaObject monitor) {
        this.fMonitor = monitor;
    }

    public IJavaObject getMonitor() {
        return this.fMonitor;
    }

    public IDebugTarget getDebugTarget() {
        return this.fMonitor.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fMonitor.getLaunch();
    }

    public String getModelIdentifier() {
        return this.fMonitor.getModelIdentifier();
    }

    protected JavaMonitorThread getOwningThread0() {
        if (this.fToUpdate) {
            this.update();
        }
        return this.fOwningThread;
    }

    protected JavaMonitorThread[] getWaitingThreads0() {
        if (this.fToUpdate) {
            this.update();
        }
        return this.fWaitingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update() {
        boolean changed = false;
        boolean toRemove = false;
        ThreadMonitorManager threadMonitorManager = ThreadMonitorManager.getDefault();
        JavaMonitor javaMonitor = this;
        synchronized (javaMonitor) {
            block25: {
                block23: {
                    if (this.fToUpdate) break block23;
                    return false;
                }
                try {
                    try {
                        if (this.fMonitor.isAllocated()) {
                            IJavaThread owningThread = this.fMonitor.getOwningThread();
                            if (owningThread == null) {
                                changed = this.fOwningThread != null;
                                this.fOwningThread = null;
                            } else {
                                changed = this.fOwningThread == null || !owningThread.equals(this.fOwningThread.getThread());
                                this.fOwningThread = ThreadMonitorManager.getDefault().getJavaMonitorThread(owningThread, null);
                            }
                            IJavaThread[] waitingThreads = this.fMonitor.getWaitingThreads();
                            if (waitingThreads == null || waitingThreads.length == 0) {
                                changed = this.fWaitingThreads != null && this.fWaitingThreads.length != 0;
                                this.fWaitingThreads = new JavaMonitorThread[0];
                                toRemove = this.fOwningThread == null;
                            } else {
                                JavaMonitorThread[] tmp = new JavaMonitorThread[waitingThreads.length];
                                if (changed || this.fWaitingThreads.length != waitingThreads.length) {
                                    int i = 0;
                                    while (i < waitingThreads.length) {
                                        tmp[i] = threadMonitorManager.getJavaMonitorThread(waitingThreads[i], null);
                                        ++i;
                                    }
                                    changed = true;
                                } else {
                                    int sameThread = 0;
                                    int i = 0;
                                    while (i < waitingThreads.length) {
                                        int j = 0;
                                        while (j < this.fWaitingThreads.length) {
                                            if (this.fWaitingThreads[i].getThread().equals(waitingThreads[i])) {
                                                ++sameThread;
                                                break;
                                            }
                                            ++j;
                                        }
                                        tmp[i] = threadMonitorManager.getJavaMonitorThread(waitingThreads[i], null);
                                        ++i;
                                    }
                                    changed = sameThread != waitingThreads.length;
                                }
                                this.fWaitingThreads = tmp;
                            }
                        } else {
                            toRemove = true;
                        }
                    }
                    catch (DebugException e) {
                        this.fOwningThread = null;
                        this.fWaitingThreads = new JavaMonitorThread[0];
                        this.fToUpdate = false;
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    this.fToUpdate = false;
                    throw throwable;
                }
                this.fToUpdate = false;
            }
        }
        if (toRemove) {
            threadMonitorManager.removeJavaMonitor(this);
        } else if (changed) {
            this.fireChangeEvent(512);
        }
        return changed;
    }

    private void fireChangeEvent(int detail) {
        Object[] elements = this.fElements.toArray();
        DebugEvent[] changeEvents = new DebugEvent[elements.length];
        int i = 0;
        while (i < elements.length) {
            changeEvents[i] = new DebugEvent(elements[i], 16, detail);
            ++i;
        }
        DebugPlugin.getDefault().fireDebugEventSet(changeEvents);
    }

    public synchronized void setToUpdate() {
        if (!this.fToUpdate) {
            this.fToUpdate = true;
            if (this.fOwningThread != null) {
                this.fOwningThread.setToUpdate();
            }
            if (this.fWaitingThreads != null) {
                int i = 0;
                while (i < this.fWaitingThreads.length) {
                    this.fWaitingThreads[i].setToUpdate();
                    ++i;
                }
            }
        }
    }

    protected void addElement(JavaOwnedMonitor monitor) {
        this.fElements.add(monitor);
    }

    protected void addElement(JavaContendedMonitor monitor) {
        this.fElements.add(monitor);
    }

    public void refresh() {
        if (this.fToUpdate && !this.update()) {
            if (this.fOwningThread != null) {
                this.fOwningThread.refresh();
            }
            int i = 0;
            while (i < this.fWaitingThreads.length) {
                this.fWaitingThreads[i].refresh();
                ++i;
            }
        }
    }

    public boolean isInDeadlock() {
        return this.fIsInDeadlock;
    }

    public void setInDeadlock(boolean isInDeadlock) {
        boolean oldValue = this.fIsInDeadlock;
        this.fIsInDeadlock = isInDeadlock;
        if (oldValue != isInDeadlock) {
            this.fireChangeEvent(256);
        }
    }
}

