/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.Standard11xVM;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;

public class Standard11xVMType
extends StandardVMType {
    @Override
    protected IPath getDefaultSystemLibrary(File installLocation) {
        return IPath.fromFile((File)installLocation).append("lib").append("classes.zip");
    }

    @Override
    protected IVMInstall doCreateVMInstall(String id) {
        return new Standard11xVM(this, id);
    }

    @Override
    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        this.setDefaultRootPath("");
        return IPath.EMPTY;
    }

    @Override
    public String getName() {
        return LaunchingMessages.Standard11xVMType_Standard_1_1_x_VM_1;
    }

    @Override
    protected File getDefaultExtensionDirectory(File installLocation) {
        return null;
    }

    @Override
    protected File getDefaultEndorsedDirectory(File installLocation) {
        return null;
    }

    @Override
    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        IPath libPath = this.getDefaultSystemLibrary(installLocation);
        File lib = libPath.toFile();
        if (lib.exists()) {
            return new LibraryLocation[]{new LibraryLocation(libPath, this.getDefaultSystemLibrarySource(lib), this.getDefaultPackageRootPath())};
        }
        return new LibraryLocation[0];
    }

    @Override
    protected boolean canDetectDefaultSystemLibraries(File javaHome, File javaExecutable) {
        LibraryLocation[] locations = this.getDefaultLibraryLocations(javaHome);
        String version = this.getVMVersion(javaHome, javaExecutable);
        return locations.length > 0 && version.startsWith("1.1");
    }
}

