/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLevel;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.LocationAwareLogger;

public class JettyLogger
implements LocationAwareLogger,
Logger {
    private final JettyLoggerFactory factory;
    private final String name;
    private final String condensedName;
    private final JettyAppender appender;
    private JettyLevel level;
    private boolean hideStacks;

    public JettyLogger(JettyLoggerFactory factory, String name, JettyAppender appender) {
        this(factory, name, appender, JettyLevel.INFO, false);
    }

    public JettyLogger(JettyLoggerFactory factory, String name, JettyAppender appender, JettyLevel level, boolean hideStacks) {
        this.factory = factory;
        this.name = name;
        this.condensedName = JettyLogger.condensePackageString(name);
        this.appender = appender;
        this.level = level;
        this.hideStacks = hideStacks;
    }

    private static String condensePackageString(String classname) {
        if (classname == null || classname.isEmpty()) {
            return "";
        }
        int rawLen = classname.length();
        StringBuilder dense = new StringBuilder(rawLen);
        boolean foundStart = false;
        boolean hasPackage = false;
        int startIdx = -1;
        int endIdx = -1;
        for (int i = 0; i < rawLen; ++i) {
            char c = classname.charAt(i);
            if (!foundStart && (foundStart = Character.isJavaIdentifierStart(c))) {
                if (startIdx >= 0) {
                    dense.append(classname.charAt(startIdx));
                    hasPackage = true;
                }
                startIdx = i;
            }
            if (!foundStart) continue;
            if (Character.isJavaIdentifierPart(c)) {
                endIdx = i;
                continue;
            }
            foundStart = false;
        }
        if (startIdx >= 0 && endIdx >= startIdx) {
            if (hasPackage) {
                dense.append('.');
            }
            dense.append(classname, startIdx, endIdx + 1);
        }
        return dense.toString();
    }

    public JettyAppender getAppender() {
        return this.appender;
    }

    String getCondensedName() {
        return this.condensedName;
    }

    public JettyLevel getLevel() {
        return this.level;
    }

    public void setLevel(JettyLevel level) {
        this.level = level;
        this.factory.walkChildrenLoggers(this.getName(), logger -> logger.setLevel(level));
    }

    public String getName() {
        return this.name;
    }

    public boolean isHideStacks() {
        return this.hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this.hideStacks = hideStacks;
        this.factory.walkChildrenLoggers(this.getName(), logger -> logger.setHideStacks(hideStacks));
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arguments);
        }
    }

    public void debug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, msg, throwable);
        }
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public boolean isDebugEnabled() {
        return this.level.includes(JettyLevel.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arguments);
        }
    }

    public void error(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, msg, throwable);
        }
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.level.includes(JettyLevel.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arguments);
        }
    }

    public void info(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, msg, throwable);
        }
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isInfoEnabled() {
        return this.level.includes(JettyLevel.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arguments);
        }
    }

    public void trace(String msg, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, msg, throwable);
        }
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isTraceEnabled() {
        return this.level.includes(JettyLevel.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arg1, arg2);
        }
    }

    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, msg, throwable);
        }
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isWarnEnabled() {
        return this.level.includes(JettyLevel.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    private void emit(Level level, String msg) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, null, msg, new Object[0]);
    }

    private void emit(Level level, String format, Object arg) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        if (arg instanceof Throwable) {
            this.getAppender().emit(this, level, timestamp, threadName, (Throwable)arg, format, new Object[0]);
        } else {
            this.getAppender().emit(this, level, timestamp, threadName, null, format, arg);
        }
    }

    private void emit(Level level, String format, Object arg1, Object arg2) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        if (arg2 instanceof Throwable) {
            this.getAppender().emit(this, level, timestamp, threadName, (Throwable)arg2, format, arg1);
        } else {
            this.getAppender().emit(this, level, timestamp, threadName, null, format, arg1, arg2);
        }
    }

    private void emit(Level level, String format, Object ... arguments) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, null, format, arguments);
    }

    private void emit(Level level, String msg, Throwable throwable) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, throwable, msg, new Object[0]);
    }

    public void log(Marker marker, String fqcn, int levelInt, String message, Object[] argArray, Throwable throwable) {
        if (this.level.toInt() <= levelInt) {
            long timestamp = System.currentTimeMillis();
            String threadName = Thread.currentThread().getName();
            this.getAppender().emit(this, JettyLevel.intToLevel(levelInt).toLevel(), timestamp, threadName, throwable, message, argArray);
        }
    }

    public void log(LoggingEvent event) {
        this.getAppender().emit(this, event.getLevel(), event.getTimeStamp(), event.getThreadName(), event.getThrowable(), event.getMessage(), event.getArgumentArray());
    }

    public String toString() {
        return String.format("%s:%s:LEVEL=%s", JettyLogger.class.getSimpleName(), this.name, this.level.name());
    }
}

