/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.Member;

abstract class SourceMember<M extends Member>
extends SourceAnnotatedElement<M>
implements JavaResourceMember {
    boolean final_;
    boolean transient_;
    boolean public_;
    boolean static_;
    boolean protected_;

    SourceMember(JavaResourceModel parent, M member) {
        super(parent, member);
    }

    protected void initialize(IBinding binding) {
        this.final_ = this.buildFinal(binding);
        this.transient_ = this.buildTransient(binding);
        this.public_ = this.buildPublic(binding);
        this.static_ = this.buildStatic(binding);
        this.protected_ = this.buildProtected(binding);
    }

    protected void synchronizeWith(IBinding binding) {
        this.syncFinal(this.buildFinal(binding));
        this.syncTransient(this.buildTransient(binding));
        this.syncPublic(this.buildPublic(binding));
        this.syncStatic(this.buildStatic(binding));
        this.syncProtected(this.buildProtected(binding));
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private void syncFinal(boolean astFinal) {
        boolean old = this.final_;
        this.final_ = astFinal;
        this.firePropertyChanged("final", old, astFinal);
    }

    private boolean buildFinal(IBinding binding) {
        return binding == null ? false : Modifier.isFinal((int)binding.getModifiers());
    }

    @Override
    public boolean isTransient() {
        return this.transient_;
    }

    private void syncTransient(boolean astTransient) {
        boolean old = this.transient_;
        this.transient_ = astTransient;
        this.firePropertyChanged("transient", old, astTransient);
    }

    private boolean buildTransient(IBinding binding) {
        return binding == null ? false : Modifier.isTransient((int)binding.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    private void syncPublic(boolean astPublic) {
        boolean old = this.public_;
        this.public_ = astPublic;
        this.firePropertyChanged("public", old, astPublic);
    }

    private boolean buildPublic(IBinding binding) {
        return binding == null ? false : Modifier.isPublic((int)binding.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private void syncStatic(boolean astStatic) {
        boolean old = this.static_;
        this.static_ = astStatic;
        this.firePropertyChanged("static", old, astStatic);
    }

    private boolean buildStatic(IBinding binding) {
        return binding == null ? false : Modifier.isStatic((int)binding.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return this.protected_;
    }

    private void syncProtected(boolean astProtected) {
        boolean old = this.protected_;
        this.protected_ = astProtected;
        this.firePropertyChanged("protected", old, astProtected);
    }

    private boolean buildProtected(IBinding binding) {
        return binding == null ? false : Modifier.isProtected((int)binding.getModifiers());
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return ((Member)this.annotatedElement).matches(memberName, occurrence);
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        return super.setPrimaryAnnotation(primaryAnnotationName, supportingAnnotationNames);
    }

    @Override
    public boolean isPublicOrProtected() {
        return this.isPublic() || this.isProtected();
    }
}

