/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceEnum;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceType;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public final class SourceTypeCompilationUnit
extends SourceCompilationUnit {
    private JavaResourceAbstractType primaryType = this.buildPrimaryType();

    public SourceTypeCompilationUnit(ICompilationUnit compilationUnit, AnnotationProvider annotationProvider, AnnotationEditFormatter annotationEditFormatter, CommandContext modifySharedDocumentCommandContext) {
        super(compilationUnit, annotationProvider, annotationEditFormatter, modifySharedDocumentCommandContext);
    }

    private JavaResourceAbstractType buildPrimaryType() {
        this.openCompilationUnit();
        CompilationUnit astRoot = this.buildASTRoot();
        this.closeCompilationUnit();
        return this.buildPrimaryType(astRoot);
    }

    @Override
    protected void synchronizeWith(CompilationUnit astRoot) {
        this.syncPrimaryType(astRoot);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return this.primaryType == null ? IterableTools.emptyIterable() : IterableTools.concatenate((Iterable[])new Iterable[]{this.primaryType.getAllTypes(), this.primaryType.getAllEnums()});
    }

    @Override
    public JptResourceType getResourceType() {
        return ContentTypeTools.getResourceType(CONTENT_TYPE);
    }

    @Override
    public void resolveTypes() {
        if (this.primaryType != null) {
            AbstractTypeDeclaration td = this.getPrimaryTypeOrEnumDeclaration(this.buildASTRoot());
            if (this.primaryType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE) {
                ((JavaResourceType)this.primaryType).resolveTypes((TypeDeclaration)td);
            } else {
                ((JavaResourceEnum)this.primaryType).resolveTypes((EnumDeclaration)td);
            }
        }
    }

    @Override
    public JavaResourceAbstractType getPrimaryType() {
        return this.primaryType;
    }

    private JavaResourceAbstractType buildPrimaryType(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getPrimaryTypeOrEnumDeclaration(astRoot);
        return td == null ? null : this.buildPrimaryType(td);
    }

    private void syncPrimaryType(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getPrimaryTypeOrEnumDeclaration(astRoot);
        if (td == null) {
            this.syncPrimaryType_(null);
        } else if (this.primaryType == null || !SourceTypeCompilationUnit.typeMatchesASTNodeType(this.primaryType, td)) {
            this.syncPrimaryType_(this.buildPrimaryType(td));
        } else if (this.primaryType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE) {
            ((JavaResourceType)this.primaryType).synchronizeWith((TypeDeclaration)td);
        } else {
            ((JavaResourceEnum)this.primaryType).synchronizeWith((EnumDeclaration)td);
        }
    }

    protected static boolean typeMatchesASTNodeType(JavaResourceAbstractType type, AbstractTypeDeclaration astType) {
        return type.getAstNodeType().matches(astType.getNodeType());
    }

    private void syncPrimaryType_(JavaResourceAbstractType astType) {
        JavaResourceAbstractType old = this.primaryType;
        this.primaryType = astType;
        this.firePropertyChanged("types", old, astType);
    }

    private JavaResourceAbstractType buildPrimaryType(AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration.getNodeType() == 55) {
            return SourceType.newInstance(this, (TypeDeclaration)typeDeclaration);
        }
        if (typeDeclaration.getNodeType() == 71) {
            return SourceEnum.newInstance(this, (EnumDeclaration)typeDeclaration);
        }
        throw new IllegalArgumentException();
    }

    private AbstractTypeDeclaration getPrimaryTypeOrEnumDeclaration(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : this.types(astRoot)) {
            if (!this.nodeIsPrimaryTypeOrEnumDeclaration(atd, primaryTypeName)) continue;
            return atd.resolveBinding() == null ? null : atd;
        }
        return null;
    }

    private boolean nodeIsPrimaryTypeOrEnumDeclaration(AbstractTypeDeclaration atd, String primaryTypeName) {
        return this.nodeIsTypeOrEnumDeclaration(atd) && atd.getName().getFullyQualifiedName().equals(primaryTypeName);
    }

    private boolean nodeIsTypeOrEnumDeclaration(AbstractTypeDeclaration atd) {
        return atd.getNodeType() == 55 || atd.getNodeType() == 71;
    }

    private String getPrimaryTypeName() {
        return this.getCompilationUnitName();
    }

    private List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }
}

