/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlMixed;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlElementRefMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAdaptableAttributeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementRef;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlMixed;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlMixedAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaXmlElementRefMapping
extends AbstractJavaAdaptableAttributeMapping<XmlElementRefAnnotation>
implements JavaXmlElementRefMapping {
    protected final XmlElementRef xmlElementRef = this.buildXmlElementRef();
    protected XmlElementWrapper xmlElementWrapper;
    protected XmlMixed xmlMixed;

    public GenericJavaXmlElementRefMapping(JavaPersistentAttribute parent) {
        super(parent);
        this.initializeXmlElementWrapper();
        this.initializeXmlMixed();
    }

    @Override
    public String getKey() {
        return "xml-element-ref";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElementRef";
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlElementRef.synchronizeWithResourceModel();
        this.syncXmlElementWrapper();
        this.syncXmlMixed();
    }

    @Override
    public void update() {
        super.update();
        this.xmlElementRef.update();
        this.updateXmlElementWrapper();
        this.updateXmlMixed();
    }

    @Override
    public XmlElementRef getXmlElementRef() {
        return this.xmlElementRef;
    }

    protected XmlElementRef buildXmlElementRef() {
        return new GenericJavaXmlElementRef(this, new XmlElementRefContext());
    }

    @Override
    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    protected void setXmlElementWrapper_(XmlElementWrapper xmlElementWrapper) {
        XmlElementWrapper oldXmlElementWrapper = this.xmlElementWrapper;
        this.xmlElementWrapper = xmlElementWrapper;
        this.firePropertyChanged("xmlElementWrapper", oldXmlElementWrapper, xmlElementWrapper);
    }

    @Override
    public XmlElementWrapper addXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapper xmlElementWrapper = this.buildXmlElementWrapper();
        this.setXmlElementWrapper_(xmlElementWrapper);
        return xmlElementWrapper;
    }

    @Override
    public void removeXmlElementWrapper() {
        if (this.xmlElementWrapper == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        this.setXmlElementWrapper_(null);
    }

    protected XmlElementWrapperAnnotation getXmlElementWrapperAnnotation() {
        return (XmlElementWrapperAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    protected XmlElementWrapper buildXmlElementWrapper() {
        return new GenericJavaXmlElementWrapper(this, new GenericJavaXmlElementWrapper.SimpleContext(this.getXmlElementWrapperAnnotation()));
    }

    protected void initializeXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            this.xmlElementWrapper = this.buildXmlElementWrapper();
        }
    }

    protected void syncXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            if (this.xmlElementWrapper != null) {
                this.xmlElementWrapper.synchronizeWithResourceModel();
            } else {
                this.setXmlElementWrapper_(this.buildXmlElementWrapper());
            }
        } else {
            this.setXmlElementWrapper_(null);
        }
    }

    protected void updateXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.update();
        }
    }

    @Override
    public XmlMixed getXmlMixed() {
        return this.xmlMixed;
    }

    protected void setXmlMixed_(XmlMixed xmlMixed) {
        XmlMixed oldXmlMixed = this.xmlMixed;
        this.xmlMixed = xmlMixed;
        this.firePropertyChanged("xmlMixed", oldXmlMixed, xmlMixed);
    }

    @Override
    public XmlMixed addXmlMixed() {
        if (this.xmlMixed != null) {
            throw new IllegalStateException();
        }
        XmlMixedAnnotation annotation = (XmlMixedAnnotation)this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlMixed");
        XmlMixed xmlMixed = this.buildXmlMixed(annotation);
        this.setXmlMixed_(xmlMixed);
        return xmlMixed;
    }

    @Override
    public void removeXmlMixed() {
        if (this.xmlMixed == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlMixed");
        this.setXmlMixed_(null);
    }

    protected XmlMixedAnnotation getXmlMixedAnnotation() {
        return (XmlMixedAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlMixed");
    }

    protected XmlMixed buildXmlMixed(XmlMixedAnnotation xmlMixedAnnotation) {
        return new GenericJavaXmlMixed(this, xmlMixedAnnotation);
    }

    protected void initializeXmlMixed() {
        XmlMixedAnnotation annotation = this.getXmlMixedAnnotation();
        if (annotation != null) {
            this.xmlMixed = this.buildXmlMixed(annotation);
        }
    }

    protected void syncXmlMixed() {
        XmlMixedAnnotation annotation = this.getXmlMixedAnnotation();
        if (annotation != null) {
            if (this.xmlMixed != null) {
                this.xmlMixed.synchronizeWithResourceModel();
            } else {
                this.setXmlMixed_(this.buildXmlMixed(annotation));
            }
        } else {
            this.setXmlMixed_(null);
        }
    }

    protected void updateXmlMixed() {
        if (this.xmlMixed != null) {
            this.xmlMixed.update();
        }
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return this.xmlElementRef.getReferencedXmlTypeNames();
    }

    @Override
    public boolean isParticleMapping() {
        return true;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.xmlElementRef.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.xmlElementWrapper != null && !IterableTools.isEmpty(result = this.xmlElementWrapper.getCompletionProposals(pos))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.xmlElementRef.validate(messages, reporter);
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.validate(messages, reporter);
        }
    }

    public class XmlElementRefContext
    implements GenericJavaXmlElementRef.Context {
        @Override
        public XmlElementRefAnnotation getAnnotation() {
            return (XmlElementRefAnnotation)GenericJavaXmlElementRefMapping.this.getAnnotation();
        }

        @Override
        public JavaAttributeMapping getAttributeMapping() {
            return GenericJavaXmlElementRefMapping.this;
        }

        @Override
        public String getDefaultType() {
            return GenericJavaXmlElementRefMapping.this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
        }

        @Override
        public XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementRefMapping.this.getXmlElementWrapper();
        }
    }
}

