/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.InternalJaxbWorkspace;
import org.eclipse.jpt.jaxb.core.internal.platform.InternalJaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.internal.platform.InternalJaxbPlatformGroupConfig;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformGroupConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class InternalJaxbPlatformManager
implements JaxbPlatformManager {
    private final InternalJaxbWorkspace jaxbWorkspace;
    private final HashMap<String, InternalJaxbPlatformGroupConfig> jaxbPlatformGroupConfigs = new HashMap();
    private final HashMap<String, InternalJaxbPlatformConfig> jaxbPlatformConfigs = new HashMap();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "jaxbPlatforms";
    private static final String JAXB_PLATFORM_GROUP_ELEMENT = "jaxbPlatformGroup";
    private static final String JAXB_PLATFORM_ELEMENT = "jaxbPlatform";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String FACTORY_CLASS_ATTRIBUTE = "factoryClass";
    private static final String JAXB_FACET_VERSION_ATTRIBUTE = "jaxbFacetVersion";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String GROUP_ATTRIBUTE = "group";
    private static final String DEFAULT_JAXB_PLATFORM_PREF_KEY_BASE = "defaultJaxbPlatform_";

    public InternalJaxbPlatformManager(InternalJaxbWorkspace jaxbWorkspace) {
        this.jaxbWorkspace = jaxbWorkspace;
        this.initialize();
    }

    private void initialize() {
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        ArrayList<IConfigurationElement> jaxbPlatformGroupElements = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> jaxbPlatformElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(JAXB_PLATFORM_GROUP_ELEMENT)) {
                    jaxbPlatformGroupElements.add(element);
                } else if (elementName.equals(JAXB_PLATFORM_ELEMENT)) {
                    jaxbPlatformElements.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : jaxbPlatformGroupElements) {
            InternalJaxbPlatformGroupConfig config = this.buildPlatformGroupConfig(element);
            if (config == null) continue;
            this.jaxbPlatformGroupConfigs.put(config.getId(), config);
        }
        for (IConfigurationElement element : jaxbPlatformElements) {
            InternalJaxbPlatformConfig config = this.buildPlatformConfig(element);
            if (config == null) continue;
            this.jaxbPlatformConfigs.put(config.getId(), config);
        }
    }

    private InternalJaxbPlatformGroupConfig buildPlatformGroupConfig(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (id == null) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.jaxbPlatformGroupConfigs.containsKey(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String label = element.getAttribute(LABEL_ATTRIBUTE);
        if (label == null) {
            this.logMissingAttribute(element, LABEL_ATTRIBUTE);
            return null;
        }
        InternalJaxbPlatformGroupConfig config = new InternalJaxbPlatformGroupConfig(this, id, label);
        config.setPluginId(contributor);
        return config;
    }

    private InternalJaxbPlatformConfig buildPlatformConfig(IConfigurationElement element) {
        String groupID;
        String defaultString;
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (id == null) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.jaxbPlatformConfigs.containsKey(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String label = element.getAttribute(LABEL_ATTRIBUTE);
        if (label == null) {
            this.logMissingAttribute(element, LABEL_ATTRIBUTE);
            return null;
        }
        String factoryClassName = element.getAttribute(FACTORY_CLASS_ATTRIBUTE);
        if (factoryClassName == null) {
            this.logMissingAttribute(element, FACTORY_CLASS_ATTRIBUTE);
            return null;
        }
        InternalJaxbPlatformConfig config = new InternalJaxbPlatformConfig(this, id, label, factoryClassName);
        String jaxbFacetVersionString = element.getAttribute(JAXB_FACET_VERSION_ATTRIBUTE);
        if (jaxbFacetVersionString != null) {
            IProjectFacetVersion jaxbFacetVersion = JaxbProject.FACET.getVersion(jaxbFacetVersionString);
            if (jaxbFacetVersion == null) {
                this.logInvalidValue(element, JAXB_FACET_VERSION_ATTRIBUTE, jaxbFacetVersionString);
                return null;
            }
            config.setJaxbFacetVersion(jaxbFacetVersion);
        }
        if ((defaultString = element.getAttribute(DEFAULT_ATTRIBUTE)) != null) {
            Boolean default_;
            Boolean bl = defaultString.equals("true") ? Boolean.TRUE : (default_ = defaultString.equals("false") ? Boolean.FALSE : null);
            if (default_ == null) {
                this.logInvalidValue(element, DEFAULT_ATTRIBUTE, defaultString);
                return null;
            }
            config.setDefault(default_);
        }
        if ((groupID = element.getAttribute(GROUP_ATTRIBUTE)) != null) {
            InternalJaxbPlatformGroupConfig groupConfig = this.jaxbPlatformGroupConfigs.get(groupID);
            if (groupConfig == null) {
                this.logInvalidValue(element, GROUP_ATTRIBUTE, groupID);
                return null;
            }
            config.setGroup(groupConfig);
            groupConfig.addPlatform(config);
        }
        config.setPluginId(contributor);
        return config;
    }

    public void initializeDefaultPreferences() {
        for (IProjectFacetVersion jaxbFacetVersion : this.getJaxbFacetVersions()) {
            this.initializeDefaultPreference(jaxbFacetVersion);
        }
    }

    private Set<IProjectFacetVersion> getJaxbFacetVersions() {
        return JaxbProject.FACET.getVersions();
    }

    private void initializeDefaultPreference(IProjectFacetVersion jaxbFacetVersion) {
        JaxbPlatformConfig config = this.buildDefaultJaxbPlatformConfig(jaxbFacetVersion);
        if (config != null) {
            this.getPlugin().setDefaultPreference(this.buildDefaultJaxbPlatformPreferenceKey(jaxbFacetVersion), config.getId());
        }
    }

    private JaxbPlatformConfig buildDefaultJaxbPlatformConfig(IProjectFacetVersion jaxbFacetVersion) {
        JaxbPlatformConfig config = this.selectJaxbPlatformConfig(this.getDefaultJaxbPlatformConfigs(), jaxbFacetVersion);
        if (config != null) {
            return config;
        }
        config = this.selectJaxbPlatformConfig(this.getInternalJaxbPlatformConfigs(), jaxbFacetVersion);
        if (config != null) {
            return config;
        }
        this.logError(JptJaxbCoreMessages.INVALID_FACET, jaxbFacetVersion);
        return null;
    }

    private String buildDefaultJaxbPlatformPreferenceKey(IProjectFacetVersion jaxbFacetVersion) {
        return DEFAULT_JAXB_PLATFORM_PREF_KEY_BASE + jaxbFacetVersion.getVersionString();
    }

    @Override
    public JaxbPlatformDefinition getJaxbPlatformDefinition(String jaxbPlatformID) {
        InternalJaxbPlatformConfig config = this.jaxbPlatformConfigs.get(jaxbPlatformID);
        return config == null ? null : config.getJaxbPlatformDefinition();
    }

    @Override
    public Iterable<JaxbPlatformGroupConfig> getJaxbPlatformGroupConfigs() {
        return new SuperIterableWrapper(this.jaxbPlatformGroupConfigs.values());
    }

    @Override
    public JaxbPlatformGroupConfig getJaxbPlatformGroupConfig(String groupID) {
        return this.jaxbPlatformGroupConfigs.get(groupID);
    }

    @Override
    public Iterable<JaxbPlatformConfig> getJaxbPlatformConfigs() {
        return new SuperIterableWrapper(this.jaxbPlatformConfigs.values());
    }

    @Override
    public JaxbPlatformConfig getJaxbPlatformConfig(String jaxbPlatformID) {
        return this.jaxbPlatformConfigs.get(jaxbPlatformID);
    }

    @Override
    public Iterable<JaxbPlatformConfig> getJaxbPlatformConfigs(IProjectFacetVersion jaxbFacetVersion) {
        return this.selectJaxbPlatformConfigs(this.getJaxbPlatformConfigs(), jaxbFacetVersion);
    }

    private JaxbPlatformConfig selectJaxbPlatformConfig(Iterable<JaxbPlatformConfig> configs, IProjectFacetVersion jaxbFacetVersion) {
        Iterator<JaxbPlatformConfig> stream = this.selectJaxbPlatformConfigs(configs, jaxbFacetVersion).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    private Iterable<JaxbPlatformConfig> selectJaxbPlatformConfigs(Iterable<JaxbPlatformConfig> configs, IProjectFacetVersion jaxbFacetVersion) {
        return IterableTools.filter(configs, (Predicate)new JaxbPlatformConfig.SupportsJaxbFacetVersion(jaxbFacetVersion));
    }

    private Iterable<JaxbPlatformConfig> getDefaultJaxbPlatformConfigs() {
        return IterableTools.filter(this.getJaxbPlatformConfigs(), JaxbPlatformConfig.IS_DEFAULT);
    }

    private Iterable<JaxbPlatformConfig> getInternalJaxbPlatformConfigs() {
        return IterableTools.filter(this.getJaxbPlatformConfigs(), this.buildInternalJaxbPlatformConfigFilter());
    }

    private Predicate<JaxbPlatformConfig> buildInternalJaxbPlatformConfigFilter() {
        return new FactoryClassNameStartsWith(this.getPluginID());
    }

    @Override
    public JaxbPlatformConfig getDefaultJaxbPlatformConfig(IProjectFacetVersion jaxbFacetVersion) {
        String key = this.buildDefaultJaxbPlatformPreferenceKey(jaxbFacetVersion);
        String id = this.getPlugin().getPreference(key);
        return id == null ? null : this.getJaxbPlatformConfig(id);
    }

    @Override
    public void setDefaultJaxbPlatformConfig(IProjectFacetVersion jaxbFacetVersion, JaxbPlatformConfig config) {
        String key = this.buildDefaultJaxbPlatformPreferenceKey(jaxbFacetVersion);
        this.getPlugin().setPreference(key, config.getId());
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage((IConfigurationElement)element, (String)attributeName));
    }

    private void logInvalidValue(IConfigurationElement element, String nodeName, String invalidValue) {
        this.getPlugin().logError(ExtensionPointTools.buildInvalidValueMessage((IConfigurationElement)element, (String)nodeName, (String)invalidValue));
    }

    @Override
    public JaxbWorkspace getJaxbWorkspace() {
        return this.jaxbWorkspace;
    }

    String getExtensionPointName() {
        return String.valueOf(this.getPluginID()) + '.' + SIMPLE_EXTENSION_POINT_NAME;
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptJaxbCorePlugin getPlugin() {
        return JptJaxbCorePlugin.instance();
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }

    static class FactoryClassNameStartsWith
    extends CriterionPredicate<JaxbPlatformConfig, String> {
        FactoryClassNameStartsWith(String prefix) {
            super((Object)prefix);
        }

        public boolean evaluate(JaxbPlatformConfig config) {
            return config.getFactoryClassName().startsWith((String)this.criterion);
        }
    }
}

