/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.utility;

import java.util.Vector;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.exception.CompositeException;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedObject;
import org.eclipse.jpt.jaxb.core.utility.Synchronizer;

public class SynchronousSynchronizer
implements Synchronizer {
    private final Command command;
    final SynchronizedObject<State> state;
    final Vector<Throwable> exceptions = new Vector();

    public SynchronousSynchronizer(Command command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command;
        this.state = new SynchronizedObject((Object)State.STOPPED, (Object)this);
    }

    @Override
    public synchronized void start() {
        switch ((State)((Object)this.state.getValue())) {
            case STOPPED: {
                this.state.setValue((Object)State.READY);
                this.synchronize();
                break;
            }
            case READY: 
            case EXECUTING: 
            case REPEAT: 
            case STOPPING: {
                throw this.buildISE();
            }
        }
    }

    @Override
    public void synchronize() {
        if (this.beginSynchronization()) {
            this.synchronize_();
        }
    }

    private synchronized boolean beginSynchronization() {
        switch ((State)((Object)this.state.getValue())) {
            case STOPPED: {
                return false;
            }
            case READY: {
                this.state.setValue((Object)State.EXECUTING);
                return true;
            }
            case EXECUTING: {
                this.state.setValue((Object)State.REPEAT);
                return false;
            }
            case REPEAT: {
                return false;
            }
            case STOPPING: {
                return false;
            }
        }
        throw this.buildISE();
    }

    private void synchronize_() {
        do {
            this.execute();
        } while (this.repeatSynchronization());
    }

    private void execute() {
        try {
            this.execute_();
        }
        catch (Throwable ex) {
            this.exceptions.add(ex);
        }
    }

    void execute_() {
        this.command.execute();
    }

    private synchronized boolean repeatSynchronization() {
        switch ((State)((Object)this.state.getValue())) {
            case STOPPED: 
            case READY: {
                throw this.buildISE();
            }
            case EXECUTING: {
                this.state.setValue((Object)State.READY);
                return false;
            }
            case REPEAT: {
                this.state.setValue((Object)State.EXECUTING);
                return true;
            }
            case STOPPING: {
                this.state.setValue((Object)State.STOPPED);
                return false;
            }
        }
        throw this.buildISE();
    }

    @Override
    public synchronized void stop() {
        switch ((State)((Object)this.state.getValue())) {
            case STOPPED: {
                throw this.buildISE();
            }
            case READY: {
                this.state.setValue((Object)State.STOPPED);
                break;
            }
            case EXECUTING: 
            case REPEAT: {
                this.state.setValue((Object)State.STOPPING);
                this.waitUntilStopped();
                break;
            }
            case STOPPING: {
                throw this.buildISE();
            }
        }
        if (this.exceptions.size() > 0) {
            Throwable[] temp = this.exceptions.toArray(new Throwable[this.exceptions.size()]);
            this.exceptions.clear();
            throw new CompositeException(temp);
        }
    }

    private void waitUntilStopped() {
        try {
            this.state.waitUntilValueIs((Object)State.STOPPED);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IllegalStateException buildISE() {
        return new IllegalStateException("state: " + this.state);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.state);
    }

    static enum State {
        STOPPED,
        READY,
        EXECUTING,
        REPEAT,
        STOPPING;

    }
}

