/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.plugin;

import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.jpa.core.internal.InternalJpaWorkspace;
import org.osgi.framework.BundleContext;

public class JptJpaCorePlugin
extends JptPlugin {
    private final Hashtable<IWorkspace, InternalJpaWorkspace> jpaWorkspaces = new Hashtable();
    private static volatile JptJpaCorePlugin INSTANCE;

    public static JptJpaCorePlugin instance() {
        return INSTANCE;
    }

    protected void setInstance(JptPlugin plugin) {
        INSTANCE = (JptJpaCorePlugin)plugin;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.disposeJpaWorkspaces();
        }
        finally {
            super.stop(context);
        }
    }

    protected String getPersistentPropertyPluginID() {
        return this.getPluginID();
    }

    protected String getOriginalPluginID_() {
        String pluginID = this.getPluginID();
        return pluginID == null ? null : pluginID.replace(".jpa", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalJpaWorkspace getJpaWorkspace(IWorkspace workspace) {
        Hashtable<IWorkspace, InternalJpaWorkspace> hashtable = this.jpaWorkspaces;
        synchronized (hashtable) {
            return this.getJpaWorkspace_(workspace);
        }
    }

    private InternalJpaWorkspace getJpaWorkspace_(IWorkspace workspace) {
        InternalJpaWorkspace jpaWorkspace = this.jpaWorkspaces.get(workspace);
        if (jpaWorkspace == null && this.isActive()) {
            jpaWorkspace = this.buildJpaWorkspace(workspace);
            this.jpaWorkspaces.put(workspace, jpaWorkspace);
        }
        return jpaWorkspace;
    }

    private InternalJpaWorkspace buildJpaWorkspace(IWorkspace workspace) {
        return new InternalJpaWorkspace(workspace);
    }

    private void disposeJpaWorkspaces() {
        for (InternalJpaWorkspace jpaWorkspace : this.jpaWorkspaces.values()) {
            try {
                jpaWorkspace.dispose();
            }
            catch (Throwable ex) {
                this.logError(ex);
            }
        }
        this.jpaWorkspaces.clear();
    }
}

