/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;

class FauxCatalogStrategy
implements CatalogStrategy {
    private final Database database;

    FauxCatalogStrategy(Database database) {
        this.database = database;
    }

    @Override
    public boolean supportsCatalogs() {
        return false;
    }

    @Override
    public List<Catalog> getCatalogs() {
        return Collections.emptyList();
    }

    @Override
    public List<Schema> getSchemas() {
        EList catalogs = this.database.getCatalogs();
        if (catalogs == null || catalogs.isEmpty()) {
            return this.database.getSchemas();
        }
        return this.getFauxCatalog().getSchemas();
    }

    private Catalog getFauxCatalog() {
        List<Catalog> catalogs = this.getCatalogs_();
        if (catalogs == null) {
            throw new IllegalStateException("catalogs list is null");
        }
        if (catalogs.size() != 1) {
            throw new IllegalStateException("not a single catalog: " + catalogs);
        }
        Catalog catalog = catalogs.get(0);
        if (catalog.getName().length() != 0) {
            throw new IllegalStateException("illegal name: " + catalog.getName());
        }
        return catalog;
    }

    private List<Catalog> getCatalogs_() {
        return this.database.getCatalogs();
    }
}

