/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpa2.persistence;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.connection.Connection2_0;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.jpa2.persistence.JptJpaUiPersistenceMessages2_0;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class JdbcConnectionPropertiesComposite2_0
extends Pane<Connection2_0> {
    private static final String DIALOG_SETTINGS = "org.eclipse.jpt.jpa.ui.internal.jpa2.dialogs.ConnectionDialog";

    public JdbcConnectionPropertiesComposite2_0(Pane<Connection2_0> parentComposite, Composite parent, PropertyValueModel<Boolean> enabledModel) {
        super(parentComposite, parent, enabledModel);
    }

    private ModifiablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<Connection2_0, String>(this.getSubjectHolder(), new String[]{"password"}){

            protected String buildValue_() {
                return ((Connection2_0)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection2_0)this.subject).setPassword(value);
            }
        };
    }

    private Runnable buildPopulateFromConnectionAction() {
        return new Runnable(){

            @Override
            public void run() {
                JdbcConnectionPropertiesComposite2_0.this.promptConnection();
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildUrlHolder() {
        return new PropertyAspectAdapter<Connection2_0, String>(this.getSubjectHolder(), new String[]{"url"}){

            protected String buildValue_() {
                return ((Connection2_0)this.subject).getUrl();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection2_0)this.subject).setUrl(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildUserHolder() {
        return new PropertyAspectAdapter<Connection2_0, String>(this.getSubjectHolder(), new String[]{"user"}){

            protected String buildValue_() {
                return ((Connection2_0)this.subject).getUser();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection2_0)this.subject).setUser(value);
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        Hyperlink hyperLink = this.addHyperlink(container, JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_POPULATE_FROM_CONNECTION_HYPER_LINK, this.buildPopulateFromConnectionAction());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        hyperLink.setLayoutData((Object)gridData);
        this.addLabel(container, JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_DRIVER_LABEL);
        this.initializeJdbcDriverClassChooser(container);
        this.addLabel(container, JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_URL_LABEL);
        this.addText(container, this.buildUrlHolder());
        this.addLabel(container, JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_USER_LABEL);
        this.addText(container, this.buildUserHolder());
        this.addLabel(container, JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_PASSWORD_LABEL);
        this.addPasswordText(container, this.buildPasswordHolder());
    }

    void promptConnection() {
        ConnectionSelectionDialog dialog = new ConnectionSelectionDialog();
        if (dialog.open() != 0) {
            return;
        }
        String name = (String)dialog.getResult()[0];
        ConnectionProfileFactory factory = this.getConnectionProfileFactory();
        ConnectionProfile cp = factory == null ? null : factory.buildConnectionProfile(name);
        Connection2_0 connection = (Connection2_0)this.getSubject();
        connection.setUrl(cp == null ? "" : cp.getURL());
        connection.setUser(cp == null ? "" : cp.getUserName());
        connection.setPassword(cp == null ? "" : cp.getUserPassword());
        connection.setDriver(cp == null ? "" : cp.getDriverClassName());
    }

    ConnectionProfileFactory getConnectionProfileFactory() {
        JpaWorkspace jpaWorkspace = this.getJpaWorkspace();
        return jpaWorkspace == null ? null : jpaWorkspace.getConnectionProfileFactory();
    }

    private JpaWorkspace getJpaWorkspace() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench == null ? null : jpaWorkbench.getJpaWorkspace();
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
    }

    Shell getShell_() {
        return this.getShell();
    }

    private ClassChooserPane<Connection2_0> initializeJdbcDriverClassChooser(Composite container) {
        return new ClassChooserPane<Connection2_0>((Pane)this, container){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<Connection2_0, String>(this.getSubjectHolder(), new String[]{"driver"}){

                    protected String buildValue_() {
                        return ((Connection2_0)this.subject).getDriver();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((Connection2_0)this.subject).setDriver(value);
                    }
                };
            }

            protected String getClassName() {
                return ((Connection2_0)this.getSubject()).getDriver();
            }

            protected IJavaProject getJavaProject() {
                return ((Connection2_0)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((Connection2_0)this.getSubject()).setDriver(className);
            }
        };
    }

    protected class ConnectionSelectionDialog
    extends FilteredItemsSelectionDialog {
        protected ConnectionSelectionDialog() {
            super(JdbcConnectionPropertiesComposite2_0.this.getShell_(), false);
            this.setMessage(JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_CONNECTION_DIALOG_MESSAGE);
            this.setTitle(JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_CONNECTION_DIALOG_TITLE);
            this.setListLabelProvider(this.buildLabelProvider());
            this.setDetailsLabelProvider(this.buildLabelProvider());
        }

        protected ILabelProvider buildLabelProvider() {
            return new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : element.toString();
                }
            };
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new ConnectionItemsFilter();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
            monitor.beginTask(null, -1);
            try {
                for (String name : this.getConnectionProfileNames()) {
                    provider.add((Object)name, itemsFilter);
                }
            }
            finally {
                monitor.done();
            }
        }

        private Iterable<String> getConnectionProfileNames() {
            ConnectionProfileFactory factory = JdbcConnectionPropertiesComposite2_0.this.getConnectionProfileFactory();
            return factory == null ? IterableTools.emptyIterable() : factory.getConnectionProfileNames();
        }

        protected IDialogSettings getDialogSettings() {
            return JptJpaUiPlugin.instance().getDialogSettings(JdbcConnectionPropertiesComposite2_0.DIALOG_SETTINGS);
        }

        public String getElementName(Object object) {
            return object.toString();
        }

        protected Comparator<String> getItemsComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String item1, String item2) {
                    return item1.compareTo(item2);
                }
            };
        }

        protected IStatus validateItem(Object item) {
            int severity = item == null ? 4 : 0;
            return JptJpaUiPlugin.instance().buildStatus(severity);
        }

        private class ConnectionItemsFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            ConnectionItemsFilter() {
                super((FilteredItemsSelectionDialog)ConnectionSelectionDialog.this);
                if (StringTools.isBlank((String)this.getPattern())) {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                return this.matches(item.toString());
            }
        }
    }
}

