/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.entity;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityClassWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityFieldsWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.EntityDataModelProvider;
import org.eclipse.jpt.jpa.ui.wizards.entity.JptJpaUiWizardsEntityMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class EntityWizard
extends DataModelWizard
implements INewWizard {
    protected String initialProjectName;
    protected IStructuredSelection selection;

    public EntityWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(JptJpaUiWizardsEntityMessages.ENTITY_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(JptJpaUiImages.ENTITY_BANNER);
    }

    public EntityWizard() {
        this(null);
    }

    protected void doAddPages() {
        EntityClassWizardPage page1 = new EntityClassWizardPage(this.getDataModel(), "pageOne", JptJpaUiWizardsEntityMessages.ENTITY_WIZARD_PAGE_DESCRIPTION, JptJpaUiWizardsEntityMessages.ENTITY_WIZARD_PAGE_TITLE);
        page1.setProjectName(this.initialProjectName);
        this.addPage((IWizardPage)page1);
        EntityFieldsWizardPage page2 = new EntityFieldsWizardPage(this.getDataModel(), "pageTwo");
        this.addPage((IWizardPage)page2);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new EntityDataModelProvider();
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
            IFile file = (IFile)javaProject.findType(className).getResource();
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            JptJpaUiPlugin.instance().logError(cantOpen);
        }
    }

    private void openEditor(final IFile file) {
        if (this.getDataModel().getBooleanProperty("NewJavaClassDataModel.OPEN_IN_EDITOR") && file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = WorkbenchTools.getActivePage();
                        if (page != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                    }
                    catch (PartInitException e) {
                        JptJpaUiPlugin.instance().logError(e);
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
        this.initialProjectName = this.extractProjectName(sel.getFirstElement());
        this.getDataModel();
    }

    protected String extractProjectName(Object object) {
        if (object == null) {
            return null;
        }
        IResource resource = (IResource)PlatformTools.getAdapter((Object)object, IResource.class);
        if (resource != null) {
            return resource.getProject().getName();
        }
        IJavaElement javaElement = (IJavaElement)PlatformTools.getAdapter((Object)object, IJavaElement.class);
        if (javaElement != null) {
            return javaElement.getJavaProject().getProject().getName();
        }
        JpaContextModel node = (JpaContextModel)PlatformTools.getAdapter((Object)object, JpaContextModel.class);
        if (node != null) {
            return node.getJpaProject().getProject().getName();
        }
        return null;
    }
}

