/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.EntityRow;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.IEntityDataModelProperties;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.operation.NewEntityClassOperation;
import org.eclipse.jpt.jpa.ui.wizards.entity.JptJpaUiWizardsEntityMessages;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class EntityDataModelProvider
extends NewJavaClassDataModelProvider
implements IEntityDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new NewEntityClassOperation(this.getDataModel());
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEntityDataModelProperties.INHERITANCE");
        propertyNames.add("IEntityDataModelProperties.ENTITY");
        propertyNames.add("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS");
        propertyNames.add("IEntityDataModelProperties.INHERITANCE_STRATEGY");
        propertyNames.add("IEntityDataModelProperties.XML_SUPPORT");
        propertyNames.add("IEntityDataModelProperties.XML_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_NAME");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_FIELDS");
        propertyNames.add("IEntityDataModelProperties.PK_FIELDS");
        propertyNames.add("IEntityDataModelProperties.FIELD_ACCESS_TYPE");
        propertyNames.add("IEntityDataModelProperties.PROPERTY_ACCESS_TYPE");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            IContainer container = this.getDefaultJavaSourceContainer();
            return container == null ? null : container.getFullPath().toString();
        }
        if (propertyName.equals("IEntityDataModelProperties.INHERITANCE")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_SUPPORT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME_DEFAULT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.INHERITANCE_STRATEGY")) {
            return "";
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.FIELD_ACCESS_TYPE")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.PROPERTY_ACCESS_TYPE")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    protected IFolder getDefaultJavaSourceFolder() {
        return null;
    }

    protected IContainer getDefaultJavaSourceContainer() {
        JpaProject jpaProject = this.getTargetJpaProject();
        if (jpaProject == null) {
            return null;
        }
        IJavaProject javaProject = jpaProject.getJavaProject();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
                if (pfr.getKind() == 1) {
                    return (IContainer)pfr.getUnderlyingResource();
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JptJpaUiPlugin.instance().logError(jme);
        }
        return null;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (ok) {
            if ("IArtifactEditOperationDataModelProperties.COMPONENT_NAME".equals(propertyName) || "IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName)) {
                this.model.notifyPropertyChange("NewJavaClassDataModel.SOURCE_FOLDER", 2);
            }
            if ("IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName) || "IEntityDataModelProperties.XML_SUPPORT".equals(propertyName)) {
                this.model.notifyPropertyChange("IEntityDataModelProperties.XML_NAME", 4);
            }
        }
        return ok;
    }

    public IStatus validate(String propertyName) {
        IStatus result = super.validate(propertyName);
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && "".equals(this.getStringProperty(propertyName))) {
            return WTPCommonPlugin.OK_STATUS;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return this.validateXmlName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return this.validateFieldsList((ArrayList)this.getProperty(propertyName));
        }
        return result;
    }

    protected IStatus validateJavaSourceFolder(String containerFullPath) {
        if (containerFullPath == null || containerFullPath.length() == 0) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!new Path(containerFullPath).isAbsolute()) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_ABSOLUTE;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_EXIST;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!project.isAccessible()) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_EXIST;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!ProjectTools.isJavaProject((IProject)project)) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_NOT_JAVA_PROJECT;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        IContainer container = this.getJavaSourceContainer();
        if (container == null || !container.getFullPath().equals((Object)new Path(containerFullPath))) {
            String msg = J2EECommonMessages.getResourceString((String)J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_SOURCE, (Object[])new String[]{containerFullPath});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName == null || packName.equals("")) {
            return WTPCommonPlugin.createWarningStatus((String)JptJpaUiWizardsEntityMessages.DEFAULT_PACKAGE_WARNING);
        }
        IStatus javaStatus = JavaConventions.validatePackageName((String)packName, (String)"1.5", (String)"1.5");
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateXmlName(String xmlName) {
        String projectName;
        IProject project;
        if (this.getBooleanProperty("IEntityDataModelProperties.XML_SUPPORT") && (project = ProjectUtilities.getProject((String)(projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME")))) != null) {
            JptXmlResource ormXmlResource;
            JptXmlResource jptXmlResource = ormXmlResource = StringTools.isBlank((String)xmlName) ? null : this.getOrmXmlResource(xmlName);
            if (ormXmlResource == null) {
                return JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.INVALID_XML_NAME);
            }
            JpaProject jpaProject = this.getTargetJpaProject();
            if (jpaProject == null || jpaProject.getJpaFile(ormXmlResource.getFile()).getRootStructureNodesSize() == 0) {
                return JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.MAPPING_FILE_NOT_LISTED_ERROR);
            }
        }
        return Status.OK_STATUS;
    }

    protected JptXmlResource getOrmXmlResource(String xmlName) {
        JpaProject jpaProject = this.getTargetJpaProject();
        return jpaProject == null ? null : jpaProject.getMappingFileXmlResource((IPath)new Path(xmlName));
    }

    private IStatus validateFieldsList(ArrayList<EntityRow> entities) {
        if (entities != null && !entities.isEmpty()) {
            boolean dup = this.hasDuplicatesInEntityFields(entities);
            if (dup) {
                String msg = JptJpaUiWizardsEntityMessages.DUPLICATED_ENTITY_NAMES_MESSAGE;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            String errorMsg = this.checkInputElementsTypeValidation(entities);
            if (errorMsg != null) {
                return WTPCommonPlugin.createErrorStatus((String)errorMsg);
            }
            String warningMsg = this.checkInputElementsTypeExistence(entities);
            if (warningMsg != null) {
                return WTPCommonPlugin.createWarningStatus((String)warningMsg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private String checkInputElementsTypeValidation(List<EntityRow> inputElements) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EntityRow entityRow : inputElements) {
            String elementSignature;
            if (entityRow.isKey() && !entityRow.couldBeKey()) {
                validateFieldTypeStatus = JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.ENTITY_DATA_MODEL_PROVIDER_INVALID_PK_TYPE, new Object[]{entityRow.getFqnTypeName()});
                break;
            }
            String sig = null;
            try {
                sig = Signature.createTypeSignature((String)entityRow.getFqnTypeName(), (boolean)true);
            }
            catch (IllegalArgumentException ex) {
                validateFieldTypeStatus = JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.ENTITY_DATA_MODEL_PROVIDER_INVALID_ARGUMENT, new Object[]{ex.getLocalizedMessage()});
                break;
            }
            if (sig == null) {
                validateFieldTypeStatus = JavaConventions.validateJavaTypeName((String)entityRow.getType(), (String)"1.5", (String)"1.5");
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType != 2 && sigType == 4 && Signature.getTypeSignatureKind((String)(elementSignature = Signature.getElementType((String)sig))) != 2) continue;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private String checkInputElementsTypeExistence(List<EntityRow> inputElements) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EntityRow entityRow : inputElements) {
            String sig = Signature.createTypeSignature((String)entityRow.getFqnTypeName(), (boolean)true);
            if (sig == null) {
                validateFieldTypeStatus = JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.ENTITY_DATA_MODEL_PROVIDER_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{entityRow.getFqnTypeName()});
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType == 2) continue;
            if (sigType == 4) {
                String elementSignature = Signature.getElementType((String)sig);
                if (Signature.getTypeSignatureKind((String)elementSignature) == 2) continue;
                String qualifiedName = Signature.toString((String)elementSignature);
                IProject project = (IProject)this.getProperty("NewJavaClassDataModel.PROJECT");
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType type = null;
                try {
                    type = javaProject.findType(qualifiedName);
                }
                catch (JavaModelException e) {
                    validateFieldTypeStatus = e.getStatus();
                    break;
                }
                if (type != null) continue;
                validateFieldTypeStatus = JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.ENTITY_DATA_MODEL_PROVIDER_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{entityRow.getFqnTypeName()});
                break;
            }
            IProject project = (IProject)this.getProperty("NewJavaClassDataModel.PROJECT");
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            try {
                type = javaProject.findType(entityRow.getFqnTypeName());
            }
            catch (JavaModelException e) {
                validateFieldTypeStatus = e.getStatus();
                break;
            }
            if (type != null) continue;
            validateFieldTypeStatus = JptJpaUiPlugin.instance().buildErrorStatus(JptJpaUiWizardsEntityMessages.ENTITY_DATA_MODEL_PROVIDER_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{entityRow.getFqnTypeName()});
            break;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private boolean hasDuplicatesInEntityFields(ArrayList<EntityRow> input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        int i = 0;
        while (i < n) {
            EntityRow entity = input.get(i);
            int j = i + 1;
            while (j < n) {
                EntityRow intEntity = input.get(j);
                if (intEntity.getName().equals(entity.getName())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected JpaProject getTargetJpaProject() {
        IProject project = this.getTargetProject();
        return project != null && ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET) ? this.getJpaProject(project) : null;
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected IContainer getJavaSourceContainer() {
        String containerFullPath = this.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        JpaProject jpaProject = this.getTargetJpaProject();
        if (jpaProject == null) {
            return null;
        }
        IJavaProject javaProject = jpaProject.getJavaProject();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container;
                IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
                if (pfr.getKind() == 1 && (container = (IContainer)pfr.getUnderlyingResource()).getFullPath().equals((Object)new Path(containerFullPath))) {
                    return container;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JptJpaUiPlugin.instance().logError(jme);
        }
        return null;
    }

    protected IPackageFragmentRoot getJavaPackageFragmentRoot() {
        IContainer sourceContainer;
        IJavaProject javaProject;
        JpaProject jpaProject = this.getTargetJpaProject();
        if (jpaProject != null && (javaProject = jpaProject.getJavaProject()) != null && (sourceContainer = this.getJavaSourceContainer()) != null) {
            return javaProject.getPackageFragmentRoot((IResource)sourceContainer);
        }
        return null;
    }
}

