/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizardPage;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CardinalityPage
extends NewAssociationWizardPage {
    private Label mtoDescLabel;
    private Label otmDescLabel;
    private Label otoDescLabel;
    private Label mtmDescLabel;
    private Button[] cardinalityButtons = new Button[4];

    protected CardinalityPage(ORMGenCustomizer customizer) {
        super(customizer, "CardinalityPage");
        this.setTitle(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_CARDINALITY_PAGE_TITLE);
        this.setDescription(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_CARDINALITY_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.GENERATE_ENTITIES_WIZARD_ASSOCIATION_CARDINALITY);
        CardinalitySelectionListener selectionListener = new CardinalitySelectionListener();
        this.cardinalityButtons[0] = this.createRadioButton(composite, 1, JptJpaUiWizardsEntityGenMessages.MANY_TO_ONE);
        this.cardinalityButtons[0].addSelectionListener((SelectionListener)selectionListener);
        this.cardinalityButtons[0].setSelection(true);
        this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "many-to-one");
        this.mtoDescLabel = this.createLabel(composite, 1, JptJpaUiWizardsEntityGenMessages.MANY_TO_ONE_DESC);
        this.cardinalityButtons[1] = this.createRadioButton(composite, 1, JptJpaUiWizardsEntityGenMessages.ONE_TO_MANY);
        this.cardinalityButtons[1].addSelectionListener((SelectionListener)selectionListener);
        this.otmDescLabel = this.createLabel(composite, 1, JptJpaUiWizardsEntityGenMessages.MANY_TO_ONE_DESC);
        this.cardinalityButtons[2] = this.createRadioButton(composite, 1, JptJpaUiWizardsEntityGenMessages.ONE_TO_ONE);
        this.cardinalityButtons[2].addSelectionListener((SelectionListener)selectionListener);
        this.otoDescLabel = this.createLabel(composite, 1, JptJpaUiWizardsEntityGenMessages.ONE_TO_ONE_DESC);
        this.cardinalityButtons[3] = this.createRadioButton(composite, 1, JptJpaUiWizardsEntityGenMessages.MANY_TO_MANY);
        this.mtmDescLabel = this.createLabel(composite, 1, JptJpaUiWizardsEntityGenMessages.MANY_TO_MANY_DESC);
        this.setControl((Control)composite);
        this.setPageComplete(true);
        this.cardinalityButtons[0].setFocus();
    }

    @Override
    public void updateWithNewTables() {
        String s1 = this.getReferrerTableName();
        String s2 = this.getReferencedTableName();
        String joinTableName = this.getJoinTableName();
        if (s1 == null || s2 == null) {
            return;
        }
        this.updateDescriptionText(s1, s2);
        if (joinTableName == null) {
            this.cardinalityButtons[0].setEnabled(true);
            this.cardinalityButtons[1].setEnabled(true);
            this.cardinalityButtons[2].setEnabled(true);
            this.cardinalityButtons[3].setEnabled(false);
            this.mtmDescLabel.setEnabled(false);
        } else {
            this.cardinalityButtons[0].setEnabled(false);
            this.cardinalityButtons[1].setEnabled(false);
            this.cardinalityButtons[2].setEnabled(false);
            this.cardinalityButtons[3].setEnabled(true);
            this.cardinalityButtons[3].setSelection(true);
            this.mtmDescLabel.setEnabled(true);
        }
        ((Composite)this.getControl()).layout();
    }

    private void updateDescriptionText(String s1, String s2) {
        String msg = String.format(JptJpaUiWizardsEntityGenMessages.MANY_TO_ONE_DESC, s2, s1);
        this.mtoDescLabel.setText(msg);
        msg = String.format(JptJpaUiWizardsEntityGenMessages.MANY_TO_ONE_DESC, s1, s2);
        this.otmDescLabel.setText(msg);
        msg = String.format(JptJpaUiWizardsEntityGenMessages.ONE_TO_ONE_DESC, s1, s2);
        this.otoDescLabel.setText(msg);
        msg = String.format(JptJpaUiWizardsEntityGenMessages.MANY_TO_MANY_DESC, s1, s2, s2, s1);
        this.mtmDescLabel.setText(msg);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = 30;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Button createRadioButton(Composite container, int span, String text) {
        Button btn = new Button(container, 16);
        btn.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        btn.setLayoutData((Object)gd);
        return btn;
    }

    private class CardinalitySelectionListener
    implements SelectionListener {
        private CardinalitySelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == CardinalityPage.this.cardinalityButtons[0]) {
                CardinalityPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "many-to-one");
            } else if (e.getSource() == CardinalityPage.this.cardinalityButtons[1]) {
                CardinalityPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "one-to-many");
            } else if (e.getSource() == CardinalityPage.this.cardinalityButtons[2]) {
                CardinalityPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "one-to-one");
            } else {
                CardinalityPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "many-to-many");
            }
            CardinalityPage.this.setPageComplete(true);
        }
    }
}

