/*******************************************************************************
 * Copyright (c) 2001, 2023 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;



import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.internal.J2EEConstants;


/**
 * Concrete implementer that knows how to import meta-data for a 1.2 Application Client
 */
public class AppClient12ImportStrategyImpl extends XmlBasedImportStrategyImpl {

	public static class Discriminator extends ArchiveTypeDiscriminatorImpl {
		@Override
		public boolean canImport(Archive anArchive) {
			return anArchive.containsFile(J2EEConstants.APP_CLIENT_DD_URI);
		}

		/**
		 * @see com.ibm.etools.archive.ArchiveTypeDiscriminator
		 */
		@Override
		public org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
			return new AppClient12ImportStrategyImpl();
		}

		@Override
		public String getUnableToOpenMessage() {
			return getXmlDDMessage(CommonArchiveResourceHandler.Application_Client_Jar_Fil, J2EEConstants.APP_CLIENT_DD_URI); // = "Application Client Jar File"
		}

		@Override
		public Archive createConvertedArchive() {
			return getArchiveFactory().createApplicationClientFile();
		}
	}

	protected static Discriminator discriminator;

	/**
	 * AppClient22ImportStrategy constructor comment.
	 */
	public AppClient12ImportStrategyImpl() {
		super();
	}

	/**
	 * @see com.ibm.etools.archive.ImportStrategy
	 */
	@Override
	public org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
		return getDiscriminator().createImportStrategy(old, newArchive);
	}

	public ApplicationClientFile getApplicationClientFile() {
		return (ApplicationClientFile) getArchive();
	}

	public static ArchiveTypeDiscriminator getDiscriminator() {
		if (discriminator == null) {
			discriminator = new Discriminator();
		}
		return discriminator;
	}

	/**
	 * @see com.ibm.etools.archive.ImportStrategy
	 */
	@Override
	public void importMetaData() throws Exception {
		loadDeploymentDescriptor();
	}

	public void loadDeploymentDescriptor() throws Exception {
		ApplicationClient client = null;

		client = (ApplicationClient) primLoadDeploymentDescriptor();

		getApplicationClientFile().setDeploymentDescriptor(client);
	}
}
