/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.internal.web.operations.AddServletOperation;
import org.eclipse.jst.j2ee.internal.web.operations.NewWebClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.ServletSupertypesValidator;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.validation.UrlPattern;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewServletClassDataModelProvider
extends NewWebClassDataModelProvider {
    private static final String SERVLET_SUPERCLASS = "javax.servlet.http.HttpServlet";
    private static final String[] SERVLET_INTERFACES = new String[]{"javax.servlet.Servlet"};
    private static final String ANNOTATED_TEMPLATE_DEFAULT = "servlet.javajet";
    private static final String NON_ANNOTATED_TEMPLATE_DEFAULT = "servlet.javajet";

    public IDataModelOperation getDefaultOperation() {
        return new AddServletOperation(this.model);
    }

    @Override
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewServletClassDataModel.INIT");
        propertyNames.add("NewServletClassDataModel.DESTROY");
        propertyNames.add("NewServletClassDataModel.GET_SERVLET_CONFIG");
        propertyNames.add("NewServletClassDataModel.GET_SERVLET_INFO");
        propertyNames.add("NewServletClassDataModel.SERVICE");
        propertyNames.add("NewServletClassDataModel.DO_GET");
        propertyNames.add("NewServletClassDataModel.DO_POST");
        propertyNames.add("NewServletClassDataModel.DO_PUT");
        propertyNames.add("NewServletClassDataModel.DO_DELETE");
        propertyNames.add("NewServletClassDataModel.DO_HEAD");
        propertyNames.add("NewServletClassDataModel.DO_OPTIONS");
        propertyNames.add("NewServletClassDataModel.DO_TRACE");
        propertyNames.add("NewServletClassDataModel.TO_STRING");
        propertyNames.add("NewServletClassDataModel.IS_SERVLET_TYPE");
        propertyNames.add("NewServletClassDataModel.INIT_PARAM");
        propertyNames.add("NewServletClassDataModel.URL_MAPPINGS");
        propertyNames.add("NewServletClassDataModel.ASYNC_SUPPORT");
        propertyNames.add("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE");
        propertyNames.add("NewServletClassDataModel.TEMPLATE_FILE");
        return propertyNames;
    }

    @Override
    public boolean isPropertyEnabled(String propertyName) {
        if ("NewJavaClassDataModel.ABSTRACT_METHODS".equals(propertyName)) {
            return ServletSupertypesValidator.isGenericServletSuperclass(this.model);
        }
        if ("NewServletClassDataModel.INIT".equals(propertyName) || "NewServletClassDataModel.DESTROY".equals(propertyName) || "NewServletClassDataModel.GET_SERVLET_CONFIG".equals(propertyName) || "NewServletClassDataModel.GET_SERVLET_INFO".equals(propertyName) || "NewServletClassDataModel.SERVICE".equals(propertyName)) {
            boolean genericServlet = ServletSupertypesValidator.isGenericServletSuperclass(this.model);
            boolean inherit = this.model.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS");
            return genericServlet && inherit;
        }
        if ("NewServletClassDataModel.DO_GET".equals(propertyName) || "NewServletClassDataModel.DO_POST".equals(propertyName) || "NewServletClassDataModel.DO_PUT".equals(propertyName) || "NewServletClassDataModel.DO_DELETE".equals(propertyName) || "NewServletClassDataModel.DO_HEAD".equals(propertyName) || "NewServletClassDataModel.DO_OPTIONS".equals(propertyName) || "NewServletClassDataModel.DO_TRACE".equals(propertyName)) {
            boolean httpServlet = ServletSupertypesValidator.isHttpServletSuperclass(this.model);
            boolean inherit = this.model.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS");
            return httpServlet && inherit;
        }
        return super.isPropertyEnabled(propertyName);
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if ((propertyName.equals("NewServletClassDataModel.DO_POST") || propertyName.equals("NewServletClassDataModel.DO_GET")) && ServletSupertypesValidator.isHttpServletSuperclass(this.model)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewServletClassDataModel.SERVICE") && !ServletSupertypesValidator.isHttpServletSuperclass(this.model)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewServletClassDataModel.INIT") || propertyName.equals("NewServletClassDataModel.DESTROY") || propertyName.equals("NewServletClassDataModel.GET_SERVLET_CONFIG") || propertyName.equals("NewServletClassDataModel.GET_SERVLET_INFO")) {
            if (!ServletSupertypesValidator.isGenericServletSuperclass(this.model)) {
                return Boolean.TRUE;
            }
        } else {
            if (propertyName.equals("NewServletClassDataModel.IS_SERVLET_TYPE")) {
                return Boolean.TRUE;
            }
            if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
                String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                if (className.endsWith(".jsp")) {
                    int index = className.lastIndexOf("/");
                    className = className.substring(index + 1, className.length() - 4);
                } else {
                    className = Signature.getSimpleName((String)className);
                }
                return className;
            }
            if (propertyName.equals("NewServletClassDataModel.URL_MAPPINGS")) {
                return this.getDefaultUrlMapping();
            }
            if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
                return this.getServletInterfaces();
            }
            if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
                if (this.projectUsesJakartaPackages()) {
                    return "jakarta.servlet.http.HttpServlet";
                }
                return SERVLET_SUPERCLASS;
            }
            if (propertyName.equals("NewServletClassDataModel.TEMPLATE_FILE")) {
                return "servlet.javajet";
            }
            if (propertyName.equals("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE")) {
                return "servlet.javajet";
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return this.validateSuperClassName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.INIT_PARAM")) {
            return this.validateInitParamList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.URL_MAPPINGS")) {
            return this.validateURLMappingList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            return this.validateDisplayName(this.getStringProperty(propertyName));
        }
        return super.validate(propertyName);
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = false;
        if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            this.model.notifyPropertyChange("NewJavaClassDataModel.ABSTRACT_METHODS", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.INIT", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DESTROY", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.GET_SERVLET_CONFIG", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.GET_SERVLET_INFO", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.SERVICE", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_GET", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_POST", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_PUT", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_DELETE", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_HEAD", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_OPTIONS", 3);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_TRACE", 3);
            if (!this.hasSuperClass()) {
                this.model.setProperty("NewJavaClassDataModel.ABSTRACT_METHODS", null);
                this.model.setProperty("NewServletClassDataModel.INIT", null);
                this.model.setProperty("NewServletClassDataModel.DESTROY", null);
                this.model.setProperty("NewServletClassDataModel.GET_SERVLET_CONFIG", null);
                this.model.setProperty("NewServletClassDataModel.GET_SERVLET_INFO", null);
                this.model.setProperty("NewServletClassDataModel.SERVICE", null);
                this.model.setProperty("NewServletClassDataModel.DO_GET", null);
                this.model.setProperty("NewServletClassDataModel.DO_POST", null);
                this.model.setProperty("NewServletClassDataModel.DO_PUT", null);
                this.model.setProperty("NewServletClassDataModel.DO_DELETE", null);
                this.model.setProperty("NewServletClassDataModel.DO_HEAD", null);
                this.model.setProperty("NewServletClassDataModel.DO_OPTIONS", null);
                this.model.setProperty("NewServletClassDataModel.DO_TRACE", null);
            }
            this.model.notifyPropertyChange("NewJavaClassDataModel.ABSTRACT_METHODS", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.INIT", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DESTROY", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.GET_SERVLET_CONFIG", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.GET_SERVLET_INFO", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.SERVICE", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_GET", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_POST", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_PUT", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_DELETE", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_HEAD", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_OPTIONS", 2);
            this.model.notifyPropertyChange("NewServletClassDataModel.DO_TRACE", 2);
            if (!ServletSupertypesValidator.isServletSuperclass(this.model)) {
                List ifaces = (List)this.model.getProperty("NewJavaClassDataModel.INTERFACES");
                ifaces.add("javax.servlet.Servlet");
            }
        }
        return result || super.propertySet(propertyName, propertyValue);
    }

    protected IStatus validateSuperClassName(String superclassName) {
        if (ServletSupertypesValidator.isGenericServletSuperclass(this.model)) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IStatus status = null;
        if (superclassName.trim().length() > 0 && (status = super.validate("NewJavaClassDataModel.SUPERCLASS")).getSeverity() == 4) {
            return status;
        }
        if (!ServletSupertypesValidator.isServletSuperclass(this.model)) {
            return WTPCommonPlugin.createErrorStatus((String)WebMessages.ERR_SERVLET_INTERFACE);
        }
        return status;
    }

    private Object getDefaultUrlMapping() {
        ArrayList<String[]> urlMappings = null;
        String text = (String)this.getProperty("NewServletClassDataModel.DISPLAY_NAME");
        if (text != null) {
            urlMappings = new ArrayList<String[]>();
            urlMappings.add(new String[]{"/" + text});
        }
        return urlMappings;
    }

    private IStatus validateInitParamList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_INIT_PARAMETER;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateURLMappingList(List prop) {
        if (prop != null && !prop.isEmpty()) {
            boolean dup = this.hasDuplicatesInStringArrayList(prop);
            if (dup) {
                String msg = WebMessages.ERR_DUPLICATED_URL_MAPPING;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            String isValidValue = this.validateValue(prop);
            if (isValidValue != null && isValidValue.length() > 0) {
                NLS.bind((String)WebMessages.ERR_URL_PATTERN_INVALID, (Object)isValidValue);
                String resourceString = WebMessages.getResourceString(WebMessages.ERR_URL_PATTERN_INVALID, new String[]{isValidValue});
                return WTPCommonPlugin.createErrorStatus((String)resourceString);
            }
        } else {
            String msg = WebMessages.ERR_URL_MAPPING_LIST_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private String validateValue(List prop) {
        if (prop == null) {
            return "";
        }
        int size = prop.size();
        int i = 0;
        while (i < size) {
            String urlMappingValue = ((String[])prop.get(i))[0];
            if (!UrlPattern.isValid(urlMappingValue)) {
                return urlMappingValue;
            }
            ++i;
        }
        return "";
    }

    private List getServletInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList();
            if (this.projectUsesJakartaPackages()) {
                this.interfaceList.add("jakarta.servlet.Servlet");
                if (ServletSupertypesValidator.isServletSuperclass(this.model)) {
                    this.interfaceList.remove("jakarta.servlet.Servlet");
                }
            } else {
                int i = 0;
                while (i < SERVLET_INTERFACES.length) {
                    this.interfaceList.add(SERVLET_INTERFACES[i]);
                    ++i;
                }
                if (ServletSupertypesValidator.isServletSuperclass(this.model)) {
                    this.interfaceList.remove("javax.servlet.Servlet");
                }
            }
        }
        return this.interfaceList;
    }

    private IStatus validateDisplayName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (this.getTargetProject() == null || this.getTargetComponent() == null) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getTargetProject());
        Object mObj = provider.getModelObject();
        if (mObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)mObj;
            EList servlets = webApp.getServlets();
            boolean exists = false;
            if (servlets != null && !servlets.isEmpty()) {
                int i = 0;
                while (i < servlets.size()) {
                    String name = ((Servlet)servlets.get(i)).getServletName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_NAME_EXIST, new String[]{prop});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        } else if (mObj instanceof WebApp) {
            WebApp webApp = (WebApp)mObj;
            List servlets = webApp.getServlets();
            boolean exists = false;
            if (servlets != null && !servlets.isEmpty()) {
                int i = 0;
                while (i < servlets.size()) {
                    String name = ((org.eclipse.jst.javaee.web.Servlet)servlets.get(i)).getServletName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_NAME_EXIST, new String[]{prop});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

