/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.jst.j2ee.application.internal.operations.AddWebFragmentComponentToWebApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.web.internal.facet.RuntimePresetMappingRegistry;

public abstract class WebFacetInstallDelegateForWebFragmentProjects {
    protected static void addToClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] existingEntries;
        IClasspathEntry[] iClasspathEntryArray = existingEntries = jproj.getRawClasspath();
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry existingEntry = iClasspathEntryArray[n2];
            if (existingEntry.equals(entry)) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] updated = new IClasspathEntry[existingEntries.length + 1];
        System.arraycopy(existingEntries, 0, updated, 0, existingEntries.length);
        updated[existingEntries.length] = entry;
        jproj.setRawClasspath(updated, null);
    }

    protected void installWARFacet(String j2eeVersionText, String warProjectName, IRuntime runtime, IProgressMonitor monitor) {
        IProject project = ProjectUtilities.getProject((String)warProjectName);
        if (project.exists()) {
            return;
        }
        IFacetedProjectWorkingCopy fpjwc = null;
        try {
            fpjwc = FacetedProjectFramework.createNewProject();
            fpjwc.setProjectName(warProjectName);
            if (runtime != null) {
                fpjwc.setTargetedRuntimes(Collections.singleton(runtime));
            }
            ArrayList<IProjectFacet> requiredFacets = new ArrayList<IProjectFacet>();
            requiredFacets.add(JavaFacetUtils.JAVA_FACET);
            requiredFacets.add(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            ArrayList<IProjectFacet> fixedFacets = requiredFacets;
            fpjwc.setFixedProjectFacets(new HashSet(fixedFacets));
            fpjwc.setSelectedPreset("default.configuration");
            if (j2eeVersionText != null) {
                IProjectFacetVersion defaultWarFacetVersion = fpjwc.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
                if (!defaultWarFacetVersion.getVersionString().equals(j2eeVersionText)) {
                    String presetId = null;
                    if (runtime != null) {
                        for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                            presetId = RuntimePresetMappingRegistry.INSTANCE.getPresetID(rc.getRuntimeComponentType().getId(), rc.getRuntimeComponentVersion().getVersionString(), IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getId(), j2eeVersionText);
                            if (presetId != null) break;
                        }
                    }
                    IProjectFacetVersion warFacetVersion = IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getVersion(j2eeVersionText);
                    ArrayList<IProjectFacetVersion> requiredFacetVersions = new ArrayList<IProjectFacetVersion>();
                    requiredFacetVersions.add(JavaFacetUtils.JAVA_FACET.getVersion("1.5"));
                    requiredFacetVersions.add(warFacetVersion);
                    ArrayList<IProjectFacetVersion> fixedFacetVersions = requiredFacetVersions;
                    fpjwc.setProjectFacets(new HashSet(fixedFacetVersions));
                    if (presetId != null) {
                        fpjwc.setSelectedPreset(presetId);
                    }
                }
                Set actions = fpjwc.getProjectFacetActions();
                for (IFacetedProject.Action action : actions) {
                    Object actionConfig = action.getConfig();
                    if (!(actionConfig instanceof JavaFacetInstallConfig)) continue;
                    JavaFacetInstallConfig c = (JavaFacetInstallConfig)actionConfig;
                    c.setDefaultOutputFolder((IPath)new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("dynWebOutput")));
                }
            }
            try {
                fpjwc.commitChanges(null);
            }
            catch (CoreException e) {
                J2EEPlugin.logError((CoreException)e);
            }
        }
        finally {
            if (fpjwc != null) {
                fpjwc.dispose();
            }
        }
    }

    protected void addToWar(IVirtualComponent warComp, IVirtualComponent j2eeComp, String moduleURI) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new AddWebFragmentComponentToWebApplicationDataModelProvider());
        Map map = (Map)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
        map.put(j2eeComp, moduleURI);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)warComp);
        List modList = (List)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(j2eeComp);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        try {
            dataModel.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            J2EEPlugin.logError((Throwable)e);
        }
    }

    protected void installAndAddModuletoWAR(String j2eeVersionText, String warProjectName, IRuntime runtime, IProject moduleProject, String moduleURI, IProgressMonitor monitor) {
        this.installWARFacet(j2eeVersionText, warProjectName, runtime, monitor);
        IVirtualComponent c = ComponentCore.createComponent((IProject)moduleProject);
        IProject warProject = ProjectUtilities.getProject((String)warProjectName);
        IVirtualComponent warComp = ComponentCore.createComponent((IProject)warProject);
        if (UIContextDetermination.getCurrentContext() == 102) {
            boolean isValidating = RendererFactory.getDefaultRendererFactory().isValidating();
            try {
                if (isValidating) {
                    RendererFactory.getDefaultRendererFactory().setValidating(false);
                }
                this.addToWar(warComp, c, moduleURI);
            }
            finally {
                RendererFactory.getDefaultRendererFactory().setValidating(isValidating);
            }
        } else {
            this.addToWar(warComp, c, moduleURI);
        }
    }
}

