/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.NamedMethodType;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.jst.jee.model.internal.mergers.JNDIRefsMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class EnterpriseBeanMerger
extends ModelElementMerger {
    public EnterpriseBeanMerger(SessionBean base, SessionBean toMerge, int _kind) {
        super((JavaEEObject)base, (JavaEEObject)toMerge, _kind);
    }

    SessionBean getBaseBean() {
        return (SessionBean)this.getBase();
    }

    SessionBean getToMergeBean() {
        return (SessionBean)this.getToMerge();
    }

    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        if (this.getToMerge() == null) {
            return warnings;
        }
        String beanClass = this.getBaseBean().getEjbClass();
        if (beanClass == null) {
            beanClass = this.getToMergeBean().getEjbClass();
        }
        this.getBaseBean().setEjbClass(beanClass);
        this.mergeJNDIRefs(warnings);
        this.mergeTransactionType();
        this.mergeSecurityIdentity(warnings);
        this.mergeTimeoutMethods(warnings);
        return warnings;
    }

    private void mergeTransactionType() {
        TransactionType toMergeTransaction = this.getToMergeBean().getTransactionType();
        if (!this.getBaseBean().isSetTransactionType()) {
            this.getBaseBean().setTransactionType(toMergeTransaction);
        }
    }

    private void mergeTimeoutMethods(List warnings) throws ModelException {
        NamedMethodType timeoutMethod = this.getBaseBean().getTimeoutMethod();
        if (timeoutMethod == null && this.getToMergeBean().getTimeoutMethod() != null) {
            this.getBaseBean().setTimeoutMethod((NamedMethodType)EcoreUtil.copy((EObject)((EObject)this.getToMergeBean().getTimeoutMethod())));
        }
    }

    private void mergeSecurityIdentity(List warnings) throws ModelException {
        SecurityIdentityType baseSecId = this.getBaseBean().getSecurityIdentities();
        SecurityIdentityType toMergeSecId = this.getToMergeBean().getSecurityIdentities();
        if (baseSecId == null && toMergeSecId != null) {
            this.getBaseBean().setSecurityIdentities((SecurityIdentityType)EcoreUtil.copy((EObject)((EObject)toMergeSecId)));
        }
    }

    private void mergeJNDIRefs(List warnings) throws ModelException {
        JNDIRefsMerger jndiRefsMerger = new JNDIRefsMerger((JavaEEObject)this.getBaseBean(), (JavaEEObject)this.getToMergeBean(), this.getKind());
        warnings.addAll(jndiRefsMerger.process());
    }
}

