/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.DomainSourceTypesRegistry;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainSourceModelType;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataChangeNotificationEvent;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataObserver;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataTranslator;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelMergeAssistantImpl;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;

public class DomainLoadingStrategy
implements IDomainLoadingStrategy,
IMetaDataObserver {
    protected String domain;
    private MetaDataModel _model;
    private List<IDomainSourceModelType> _sourceTypes;
    private List<IMetaDataSourceModelProvider> _sources;

    public DomainLoadingStrategy(String domain) {
        this.domain = domain;
    }

    @Override
    public void load(MetaDataModel model) {
        this._model = model;
        this._sourceTypes = this.loadDomainSourceModelTypes();
        this.sortSourceTypes(this._sourceTypes);
        this._sources = this.locateMetaDataSourceInstances(this._sourceTypes, model);
        this.mergeModel(model, this._sources);
    }

    @Override
    public void reload() throws ModelNotSetException {
        if (this._model == null) {
            throw new ModelNotSetException();
        }
        this.removeOldLocatorObservers();
        this._sources = this.locateMetaDataSourceInstances(this._sourceTypes, this._model);
        this.mergeModel(this._model, this._sources);
    }

    protected void mergeModel(MetaDataModel model, List<IMetaDataSourceModelProvider> sources) {
        StandardModelFactory.debug(">> Begin Merge: " + String.valueOf(model.getModelContext()) + "(" + sources.size() + " sources)", StandardModelFactory.DEBUG_MD_LOAD);
        IMetaDataModelMergeAssistant assistant = this.createModelMergeAssistant(model);
        for (IMetaDataSourceModelProvider mds : sources) {
            for (IMetaDataTranslator translator : mds.getLocator().getDomainSourceModelType().getTranslators()) {
                if (!translator.canTranslate(mds)) continue;
                StandardModelFactory.debug(">>> Merging: " + String.valueOf(model.getModelContext()) + "::" + String.valueOf(mds), StandardModelFactory.DEBUG_MD_LOAD);
                assistant.setSourceModelProvider(mds);
                try {
                    translator.translate(assistant);
                }
                catch (Exception e) {
                    StandardModelFactory.debug(">>>> Error during translate/merge of: " + String.valueOf(model.getModelContext()) + ": " + String.valueOf(mds), StandardModelFactory.DEBUG_MD_LOAD);
                    JSFCommonPlugin.log(4, "Error during load of: " + String.valueOf(mds), e);
                }
            }
        }
        assistant.setMergeComplete();
        StandardModelFactory.debug(">> End Merge: " + String.valueOf(model.getModelContext()), StandardModelFactory.DEBUG_MD_LOAD);
    }

    protected IMetaDataModelMergeAssistant createModelMergeAssistant(MetaDataModel model) {
        return new MetaDataModelMergeAssistantImpl(model);
    }

    protected void sortSourceTypes(List<IDomainSourceModelType> sourceTypes) {
    }

    protected List<IDomainSourceModelType> loadDomainSourceModelTypes() {
        return DomainSourceTypesRegistry.getInstance().getDomainSourceTypes(this.domain);
    }

    protected List<IMetaDataSourceModelProvider> locateMetaDataSourceInstances(List<IDomainSourceModelType> sourceTypes, MetaDataModel model) {
        ArrayList<IMetaDataSourceModelProvider> sources = new ArrayList<IMetaDataSourceModelProvider>();
        IProject project = this.getProject(model);
        for (IDomainSourceModelType sourceType : sourceTypes) {
            IMetaDataLocator locator = sourceType.getLocator(project);
            if (locator == null) continue;
            locator.setDomainSourceModelType(sourceType);
            List<IMetaDataSourceModelProvider> providers = locator.locateMetaDataModelProviders(model.getModelContext().getModelIdentifier());
            if (providers != null && !providers.isEmpty()) {
                for (IMetaDataSourceModelProvider provider : providers) {
                    provider.setLocator(locator);
                    sources.add(provider);
                }
            }
            locator.addObserver(this);
        }
        return sources;
    }

    private IProject getProject(MetaDataModel model) {
        return (IProject)model.getModelContext().getAdapter(IProject.class);
    }

    @Override
    public void notifyMetadataChanged(IMetaDataChangeNotificationEvent event) {
        this._model.setNeedsRefresh();
    }

    @Override
    public void cleanup() {
        this.removeOldLocatorObservers();
        this._sources = null;
        this._sourceTypes = null;
        this._model = null;
    }

    private void removeOldLocatorObservers() {
        if (this._sources != null) {
            for (IMetaDataSourceModelProvider provider : this._sources) {
                IMetaDataLocator locator;
                if (provider == null || (locator = provider.getLocator()) == null) continue;
                locator.removeObserver(this);
                locator.setDomainSourceModelType(null);
                provider.setLocator(null);
            }
        }
    }
}

