/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.core.internal.project.facet.JsfFacetConfigurationUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSFFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IJSFFacetInstallDataModelProperties {
    private static final String REGEX_FOR_VALID_CONFIG_FILE_NAME = "^(?!.*/{2,}.*$)[-\\w/.]+$";
    private static final Pattern PATTERN_FOR_VALID_CONFIG_FILE_NAME = Pattern.compile("^(?!.*/{2,}.*$)[-\\w/.]+$");
    private final boolean jsfFacetConfigurationEnabled = JsfFacetConfigurationUtil.isJsfFacetConfigurationEnabled();
    private LibraryInstallDelegate libraryInstallDelegate = null;
    private IPropertyChangeListener propertyChangeListener = null;
    private String errorMessage;

    private void initLibraryInstallDelegate() {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        IProjectFacetVersion fv = (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
        if (this.libraryInstallDelegate == null && fpjwc != null && fv != null) {
            this.libraryInstallDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fpjwc, fv);
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChanged(String property, Object oldValue, Object newValue) {
                    IDataModel dm = JSFFacetInstallDataModelProvider.this.getDataModel();
                    if (dm != null) {
                        dm.notifyPropertyChange("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", 1);
                    }
                }
            };
            this.libraryInstallDelegate.addListener(this.propertyChangeListener, new String[0]);
        }
    }

    public void dispose() {
        if (this.libraryInstallDelegate != null) {
            this.libraryInstallDelegate.removeListener(this.propertyChangeListener);
            this.libraryInstallDelegate.dispose();
        }
        super.dispose();
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        if (this.jsfFacetConfigurationEnabled) {
            names.add("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
            names.add("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
            names.add("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
            names.add("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
            names.add("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES");
            names.add("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR");
            names.add("IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET");
        }
        names.add("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
            return "/WEB-INF/faces-config.xml";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
            return "Faces Servlet";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME")) {
            return "javax.faces.webapp.FacesServlet";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS")) {
            return new String[]{"/faces/*"};
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.jsf";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR")) {
            return "WebContent";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return this.libraryInstallDelegate;
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES")) {
            return new JSFLibraryInternalReference[0];
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY") || propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
            this.initLibraryInstallDelegate();
            if (this.libraryInstallDelegate != null && propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
                IProjectFacetVersion fv = (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                this.libraryInstallDelegate.setProjectFacetVersion(fv);
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        this.errorMessage = null;
        if (this.jsfFacetConfigurationEnabled) {
            if (name.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
                return this.validateConfigLocation(this.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
            }
            if (name.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
                return this.validateServletName(this.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME"));
            }
            if (name.equals("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES")) {
                return this.validateClasspath();
            }
        }
        if (name.equals("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return ((LibraryInstallDelegate)this.getProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).validate();
        }
        return super.validate(name);
    }

    private IStatus createErrorStatus(String msg) {
        return new Status(4, "org.eclipse.jst.jsf.core", msg);
    }

    private IStatus validateServletName(String servletName) {
        if (servletName == null || servletName.trim().length() == 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateServletName;
            return this.createErrorStatus(this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateConfigLocation(String text) {
        if (text == null || text.trim().equals("")) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileEmpty;
            return this.createErrorStatus(this.errorMessage);
        }
        text = text.trim();
        if (this.getProjectPath() == null) {
            return OK_STATUS;
        }
        IPath fullPath = this.getProjectPath().append(text);
        Path passedPath = new Path(text);
        if (!fullPath.isValidPath(text)) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFilePath;
            return this.createErrorStatus(this.errorMessage);
        }
        if (text.toLowerCase().lastIndexOf(".xml") != text.length() - 4) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileXML;
            return this.createErrorStatus(this.errorMessage);
        }
        if (text.lastIndexOf("\\") >= 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileSlashes;
            return this.createErrorStatus(this.errorMessage);
        }
        if (passedPath.getDevice() != null) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative1, (Object)this.getWebContentFolderName());
            return this.createErrorStatus(this.errorMessage);
        }
        IPath webContentFolder = this.getWebContentFolder();
        IPath setPath = webContentFolder.append((IPath)passedPath);
        if (!this.getWebContentFolder().isPrefixOf(setPath)) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative2, (Object)this.getWebContentFolderName());
            return this.createErrorStatus(this.errorMessage);
        }
        if (!JSFFacetInstallDataModelProvider.isValidConfigFileName(text)) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_INVALID_JSF_CONFIG_FILE_NAME;
            return this.createErrorStatus(this.errorMessage);
        }
        return OK_STATUS;
    }

    public static boolean isValidConfigFileName(String configFileName) {
        return PATTERN_FOR_VALID_CONFIG_FILE_NAME.matcher(configFileName).matches();
    }

    private IStatus validateClasspath() {
        HashSet<String> jars = new HashSet<String>();
        if (this.doesProjectExist()) {
            try {
                IClasspathEntry[] entries = this.getJavaProject().getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1) {
                        jars.add(entry.getPath().makeAbsolute().toString());
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        IStatus status = null;
        JSFLibraryInternalReference[] compLibs = (JSFLibraryInternalReference[])this.getProperty("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES");
        if (compLibs != null) {
            int i = 0;
            while (i < compLibs.length) {
                JSFLibrary lib = compLibs[i].getLibrary();
                status = this.checkForDupeArchiveFiles(jars, lib);
                if (!OK_STATUS.equals(status)) {
                    return status;
                }
                ++i;
            }
        }
        return OK_STATUS;
    }

    private IJavaProject getJavaProject() {
        IProject proj = this.getProject();
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    private IProject getProject() {
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        if (projName == null || "".equals(projName)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project;
    }

    private boolean doesProjectExist() {
        IProject project = this.getProject();
        return project != null && project.exists();
    }

    private IStatus checkForDupeArchiveFiles(Set jars, JSFLibrary aJSFLib) {
        if (aJSFLib == null) {
            return OK_STATUS;
        }
        for (ArchiveFile jar : aJSFLib.getArchiveFiles()) {
            if (jars.contains(jar.getResolvedSourceLocation())) {
                return this.createErrorStatus(NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_DupeJarValidation, (Object)jar.getResolvedSourceLocation()));
            }
            jars.add(jar.getResolvedSourceLocation());
        }
        return OK_STATUS;
    }

    private IPath getProjectPath() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        if (project.exists()) {
            return project.getLocation();
        }
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IFacetedProjectWorkingCopy projModel = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (projModel.getProjectLocation() != null) {
            return projModel.getProjectLocation().append(projName);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(projName);
    }

    private IPath getWebContentFolder() {
        IPath webContentPath = null;
        String projName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        String webFolder = this.getWebContentFolderName();
        if (proj.exists()) {
            IVirtualComponent virtComponent = ComponentCore.createComponent((IProject)proj);
            if (virtComponent != null) {
                IContainer container;
                IVirtualFolder virtFolder = virtComponent.getRootFolder();
                if (virtFolder != null && (container = virtFolder.getUnderlyingFolder()) != null) {
                    webContentPath = container.getRawLocation();
                }
            } else {
                webContentPath = webFolder == null ? proj.getFullPath() : proj.getFullPath().append(webFolder);
            }
        } else {
            webContentPath = webFolder == null ? proj.getFullPath() : proj.getFullPath().append(webFolder);
        }
        return webContentPath;
    }

    private String getWebContentFolderName() {
        IContainer container;
        IVirtualFolder virtFolder;
        IVirtualComponent virtComponent;
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (project.exists() && (virtComponent = ComponentCore.createComponent((IProject)project)) != null && (virtFolder = virtComponent.getRootFolder()) != null && (container = virtFolder.getUnderlyingFolder()) != null) {
            IPath webContentPath = container.getProjectRelativePath();
            return webContentPath.toString();
        }
        IFacetedProjectWorkingCopy projWC = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        Set pfas = projWC.getProjectFacetActions();
        for (IFacetedProject.Action action : pfas) {
            if (!action.getProjectFacetVersion().getProjectFacet().getId().equals("jst.web")) continue;
            IDataModel webFacet = (IDataModel)action.getConfig();
            return webFacet.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        }
        return null;
    }
}

