/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.Messages;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.JSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDNamespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.SerializableTLDNamespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.TagRepository;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public class PersistedDataTagStrategy
extends JSPTagResolvingStrategy {
    public static final String ID = "org.eclipse.jst.jsf.designtime.PersistedDataTagStrategy";
    public static final String DISPLAY_NAME = Messages.PersistedDataTagStrategy_DisplayName;
    private final IProject _project;
    private final TagRepository _repository;
    private Map<String, SerializableTLDNamespace> _namespaces;
    private final transient AtomicBoolean _reentrancyFlag = new AtomicBoolean(false);

    public static JSPTagResolvingStrategy.StrategyDescriptor createDescriptor() {
        return new JSPTagResolvingStrategy.StrategyDescriptor(ID, DISPLAY_NAME);
    }

    public PersistedDataTagStrategy(IProject project) {
        this._project = project;
        this._repository = new TagRepository(this._project);
    }

    public void init() {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log("Initializing PersistedDataTagStrategy for project: " + this._project.toString());
        }
        try {
            this._namespaces = this._repository.load();
            return;
        }
        catch (IOException e) {
            JSFCorePlugin.log(e, "JSP tag registry cached failed to load.  Strategy will not be used");
        }
        catch (ClassNotFoundException e) {
            JSFCorePlugin.log(e, "JSP tag registry cached failed to load.  Strategy will not be used");
        }
        this._namespaces = new HashMap<String, SerializableTLDNamespace>();
    }

    public void save(Map<String, TLDNamespace> namespace) throws IOException, ClassNotFoundException {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log("Saving PersistedDataTagStrategy for project: " + this._project.toString());
        }
        for (Map.Entry<String, TLDNamespace> namespaceEntry : namespace.entrySet()) {
            TLDNamespace ns = namespaceEntry.getValue();
            String nsName = namespaceEntry.getKey();
            SerializableTLDNamespace myNs = this._namespaces.get(nsName);
            if (myNs == null) {
                if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                    JSFCoreTraceOptions.log(String.format("Adding namespace %s for project", ns.getNSUri(), this._project.toString()));
                }
                this._namespaces.put(nsName, new SerializableTLDNamespace(ns));
                continue;
            }
            if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                JSFCoreTraceOptions.log(String.format("Updating namespace %s for project", ns.getNSUri(), this._project.toString()));
            }
            for (Map.Entry<String, ITagElement> elementEntry : ns.getCurrentElements().entrySet()) {
                if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                    JSFCoreTraceOptions.log(String.format("Putting element %s", elementEntry.getKey()));
                }
                myNs.put(elementEntry.getKey(), elementEntry.getValue());
            }
        }
        this._repository.save(this._namespaces);
    }

    @Override
    public ITagElement resolve(TLDElementDeclaration element) {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log(String.format("Attempting to resolve element %s for project %s", element.getElementName(), this._project));
        }
        try {
            ITagElement tagElement;
            SerializableTLDNamespace ns;
            if (!this._reentrancyFlag.compareAndSet(false, true)) {
                throw new IllegalStateException("Reentrant call to resolve");
            }
            String uri = PersistedDataTagStrategy.getUri(element);
            String tagName = element.getElementName();
            if (uri != null && tagName != null && (ns = this._namespaces.get(uri)) != null && (tagElement = ns.getViewElement(tagName)) instanceof TLDTagElement) {
                if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                    JSFCoreTraceOptions.log(String.format("Resolved element %s for project %s", element.getElementName(), this._project));
                }
                ITagElement iTagElement = tagElement;
                return iTagElement;
            }
            ITagElement iTagElement = this.getNotFoundIndicator();
            return iTagElement;
        }
        finally {
            this._reentrancyFlag.set(false);
        }
    }

    public void clear() {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log(String.format("Flushing all data for project %s", this._project));
        }
        try {
            this._repository.clearAll();
        }
        catch (IOException e) {
            JSFCorePlugin.log(e, "Failure during cache flushing on project: " + String.valueOf(this._project));
        }
        catch (ClassNotFoundException e) {
            JSFCorePlugin.log(e, "Failure during cache flushing on project: " + String.valueOf(this._project));
        }
        this._namespaces.clear();
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    private static String getUri(TLDElementDeclaration element) {
        CMDocument owner = element.getOwnerDocument();
        if (owner instanceof TLDDocument) {
            return ((TLDDocument)owner).getUri();
        }
        return null;
    }

    @Override
    public String getId() {
        return ID;
    }
}

