/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.JSFConverterUtil;
import org.w3c.dom.Element;

public class InputTagConverter
extends AbstractTagConverter {
    private String _inputType;

    public InputTagConverter(Element host, String inputType) {
        super(host);
        this._inputType = inputType;
    }

    protected Element doConvertRefresh() {
        Element hostEle = this.getHostElement();
        Element inputEle = this.createElement("input");
        JSFConverterUtil.copyAllAttributes((Element)hostEle, (Element)inputEle, null);
        JSFConverterUtil.copyAttribute((Element)hostEle, (String)"styleClass", (Element)inputEle, (String)"class");
        inputEle.removeAttribute("styleClass");
        inputEle.setAttribute("type", this.getInputType());
        inputEle.removeAttribute("value");
        inputEle.setAttribute("value", this.getValue(hostEle));
        return inputEle;
    }

    private String getValue(Element hostEle) {
        String valueAttr = hostEle.getAttribute("value");
        if (valueAttr == null) {
            String name = hostEle.getLocalName();
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return this.mapValue(valueAttr);
    }

    private String getInputType() {
        return this._inputType;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return true;
    }
}

