/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.ConverterUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultUnknownTagConverter
extends AbstractTagConverter {
    private static final int NO_ELEMENT = 0;
    private static final int TABLE_ELEMENT = 1;
    private static final int TABLE_ROW_ELEMENT = 2;

    public DefaultUnknownTagConverter(Element host, int mode) {
        super(host);
        this.setMode(mode);
    }

    @Override
    protected Element doConvertRefresh() {
        Element hostEle = this.getHostElement();
        Node containingElement = ConverterUtil.findConvertedParentElement(hostEle, null);
        String name = null;
        if (containingElement != null) {
            name = containingElement.getNodeName();
        }
        if (name != null) {
            if ("table".equalsIgnoreCase(name) || "tbody".equalsIgnoreCase(name) || "tfoot".equalsIgnoreCase(name)) {
                return this.renderAsTableRow(hostEle, false, 1);
            }
            if ("thead".equalsIgnoreCase(name)) {
                return this.renderAsTableRow(hostEle, true, 1);
            }
            if ("tr".equalsIgnoreCase(name)) {
                return this.renderAsTableCell(hostEle, false, 2);
            }
        }
        return this.renderDefault(hostEle, 0);
    }

    private Element renderDefault(Element hostEle, int tableElement) {
        Element divEle = this.createElement("div");
        Object style = DOMUtil.getAttributeIgnoreCase(hostEle, "style");
        if (style == null) {
            style = "";
        }
        if (((String)style).length() > 0 && !((String)style).endsWith(";")) {
            style = (String)style + ";";
        }
        style = (String)style + "border: none; padding: 0; margin: 0";
        divEle.setAttribute("style", (String)style);
        Element div2 = this.createElement("span");
        String border = this.isPreviewMode() ? "border-style: solid;border-width: 1px" : "border:none";
        div2.setAttribute("style", "background-color: white;" + border + ";color:gray");
        Text txt = this.createText(hostEle.getTagName());
        div2.appendChild(txt);
        divEle.appendChild(div2);
        Element childContainer = null;
        switch (tableElement) {
            case 1: {
                childContainer = this.createElement("table");
                this.copyChildren(this.getHostElement(), childContainer);
                break;
            }
            case 2: {
                childContainer = this.createElement("table");
                Element trElem = this.createElement("tr");
                childContainer.appendChild(trElem);
                this.copyChildren(this.getHostElement(), trElem);
                break;
            }
            default: {
                childContainer = this.createElement("div");
                childContainer.setAttribute("style", "margin: 0; padding: 0");
                this.copyChildren(this.getHostElement(), childContainer);
            }
        }
        divEle.appendChild(childContainer);
        return divEle;
    }

    private Element renderAsTableRow(Element hostEle, boolean isHeader, int tableElement) {
        Element trElem = this.createElement("tr");
        Element tdElem = this.renderAsTableCell(hostEle, isHeader, tableElement);
        trElem.appendChild(tdElem);
        return trElem;
    }

    private Element renderAsTableCell(Element hostEle, boolean isHeader, int tableElement) {
        Element tdElem = null;
        tdElem = isHeader ? this.createElement("th") : this.createElement("td");
        tdElem.appendChild(this.renderDefault(hostEle, tableElement));
        return tdElem;
    }

    @Override
    public boolean isMultiLevel() {
        return true;
    }

    @Override
    public boolean isWidget() {
        return false;
    }

    @Override
    public boolean needBorderDecorator() {
        return true;
    }
}

