/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizationAction;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.common.ui.internal.utils.PluginImageHelper;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizationsHelper;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizer;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteRoot;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteContext;
import org.eclipse.jst.pagedesigner.editors.palette.Messages;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class DesignerPaletteCustomizerDialog
extends PaletteCustomizerDialog {
    private static final String DEFAULT_CUSTOMIZATIONS_EXPORT_FILENAME = "WPDPaletteCustomizations.xml";
    private static String DEFAULTEXTENSION = ".xml";
    private PropertyChangeListener applyButtonUpdater = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Button applyButton = DesignerPaletteCustomizerDialog.this.getButton(1025);
            if (applyButton == null) {
                return;
            }
            applyButton.setEnabled(true);
        }
    };

    public DesignerPaletteCustomizerDialog(Shell shell, PaletteCustomizer customizer, DesignerPaletteRoot root) {
        super(shell, customizer, (PaletteRoot)root);
    }

    public int open() {
        return super.open();
    }

    protected void setActiveEntry(PaletteEntry entry) {
        PaletteEntry pre = this.getSelectedPaletteEntry();
        if (pre != null) {
            pre.removePropertyChangeListener(this.applyButtonUpdater);
        } else {
            this.getButton(1025).setEnabled(false);
        }
        if (entry != null) {
            entry.addPropertyChangeListener(this.applyButtonUpdater);
        }
        super.setActiveEntry(entry);
    }

    protected void save() {
        super.save();
        Button applyButton = this.getButton(1025);
        if (applyButton != null) {
            applyButton.setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(1025).setEnabled(false);
    }

    public Action getImportAction() {
        return new ImportAction(this);
    }

    public Action getExportAction() {
        return new ExportAction();
    }

    protected List createOutlineActions() {
        List actions = super.createOutlineActions();
        actions.remove(0);
        actions.remove(0);
        actions.add(new ImportAction(this));
        actions.add(new ExportAction());
        return actions;
    }

    protected TreeViewer createOutlineTreeViewer(Composite composite) {
        TreeViewer viewer = super.createOutlineTreeViewer(composite);
        viewer.setContentProvider((IContentProvider)new DesignerPaletteContentProvider());
        return viewer;
    }

    private static class DesignerPaletteContentProvider
    implements ITreeContentProvider {
        private DesignerPaletteContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DesignerPaletteRoot) {
                ArrayList<PaletteEntry> libs = new ArrayList<PaletteEntry>();
                List children = ((DesignerPaletteRoot)((Object)parentElement)).getChildren();
                if (!children.isEmpty()) {
                    for (PaletteEntry entry : children) {
                        if (!(entry instanceof TaglibPaletteDrawer)) continue;
                        libs.add(entry);
                    }
                    if (!libs.isEmpty()) {
                        return libs.toArray();
                    }
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return ((PaletteEntry)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new Object[]{};
            if (inputElement instanceof DesignerPaletteRoot && (elements = this.getChildren(inputElement)) == null) {
                elements = new Object[]{};
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ExportAction
    extends PaletteCustomizationAction {
        public ExportAction() {
            this.setEnabled(true);
            this.setText(PageDesignerResources.getInstance().getString("DesignerPaletteCustomizerDialog.label.export"));
            this.setImageDescriptor(PluginImageHelper.getInstance().getImageDescriptor("icons/palette/GENERIC/small/PD_Palette_Export.gif", PDPlugin.getPluginId()));
            this.setDisabledImageDescriptor(PluginImageHelper.getInstance().getImageDescriptor("icons/palette/GENERIC/small/PD_Palette_Export_Disabled.gif", PDPlugin.getPluginId()));
            this.setHoverImageDescriptor(PluginImageHelper.getInstance().getImageDescriptor("icons/palette/GENERIC/small/PD_Palette_Export_Hover.gif", PDPlugin.getPluginId()));
        }

        private void handleExport() {
            FileDialog fileDialog = new FileDialog(PDPlugin.getActiveWorkbenchShell());
            fileDialog.setFileName(DesignerPaletteCustomizerDialog.DEFAULT_CUSTOMIZATIONS_EXPORT_FILENAME);
            String[] filterExtensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            fileDialog.setText(Messages.DesignerPaletteCustomizerDialog_ExportCustomizations);
            Object filename = fileDialog.open();
            if (filename != null) {
                if (!((String)filename).endsWith(DEFAULTEXTENSION)) {
                    filename = (String)filename + DEFAULTEXTENSION;
                }
                IPaletteContext context = PaletteItemManager.createPaletteContext(((DesignerPaletteRoot)DesignerPaletteCustomizerDialog.this.getPaletteRoot()).getFile());
                DesignerPaletteCustomizationsHelper.exportCustomizations(PaletteItemManager.getInstance(context), (String)filename);
                DesignerPaletteCustomizerDialog.this.updateActions();
            }
        }

        public void run() {
            this.handleExport();
        }

        public void update() {
            this.setEnabled(true);
        }
    }

    private class ImportAction
    extends PaletteCustomizationAction {
        private DesignerPaletteCustomizerDialog designerPaletteCustomizerDialog;

        public ImportAction(DesignerPaletteCustomizerDialog designerPaletteCustomizerDialog2) {
            this.designerPaletteCustomizerDialog = designerPaletteCustomizerDialog2;
            this.setEnabled(true);
            this.setText(PageDesignerResources.getInstance().getString("DesignerPaletteCustomizerDialog.label.import"));
            this.setImageDescriptor(PluginImageHelper.getInstance().getImageDescriptor("icons/palette/GENERIC/small/PD_Palette_Import.gif", PDPlugin.getPluginId()));
            this.setDisabledImageDescriptor(PluginImageHelper.getInstance().getImageDescriptor("icons/palette/GENERIC/small/PD_Palette_Import_Disabled.gif", PDPlugin.getPluginId()));
            this.setHoverImageDescriptor(PluginImageHelper.getInstance().getImageDescriptor("icons/palette/GENERIC/small/PD_Palette_Import_Hover.gif", PDPlugin.getPluginId()));
        }

        private void handleImport() {
            FileDialog fileDialog = new FileDialog(PDPlugin.getActiveWorkbenchShell());
            fileDialog.setFileName(DesignerPaletteCustomizerDialog.DEFAULT_CUSTOMIZATIONS_EXPORT_FILENAME);
            String[] filterExtensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            fileDialog.setText(Messages.DesignerPaletteCustomizerDialog_ImportCustomizations);
            String filename = fileDialog.open();
            if (filename != null) {
                this.designerPaletteCustomizerDialog.close();
                DesignerPaletteCustomizationsHelper.importCustomizations((DesignerPaletteCustomizer)DesignerPaletteCustomizerDialog.this.getCustomizer(), filename);
                ((DesignerPaletteCustomizer)DesignerPaletteCustomizerDialog.this.getCustomizer()).getDesignerPaletteRoot().refresh();
                this.designerPaletteCustomizerDialog.open();
            }
        }

        public void run() {
            this.handleImport();
        }

        public void update() {
        }
    }
}

