/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowUtilities;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextLayoutSupport;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.parts.SubNodeEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.CaretPositionResolver;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;
import org.w3c.dom.Node;

public final class LayoutPart {
    private static final int MAX_OFFSET_TO_EDGE = 10;
    private EditPart _part;
    private FlowBox _box;
    private final Point EMPTY_POINT;
    private Point _point;

    public LayoutPart(EditPart part, Point point) {
        this._point = this.EMPTY_POINT = new Point(0, 0);
        Assert.isTrue((part != null ? 1 : 0) != 0);
        this._part = part;
        this._point = point;
    }

    public FlowBox getBox() {
        if (this._box == null) {
            this._box = this.getClosestBox();
        }
        return this._box;
    }

    public EditPart getPart() {
        return this._part;
    }

    private Rectangle getClosestBoxAbsoluteBounds() {
        Rectangle rect = null;
        if (this.getBox() != null) {
            rect = this.getAbsoluteBounds(this.getBox());
        }
        return rect;
    }

    public Rectangle getAbsoluteBounds() {
        Rectangle bounds = null;
        bounds = this.getClosestBoxAbsoluteBounds();
        if (bounds == null) {
            bounds = EditPartPositionHelper.getAbsoluteBounds(this._part);
        }
        return bounds;
    }

    public Rectangle getAbsoluteBounds(FlowBox box) {
        if (box != null) {
            IFigure figure = ((GraphicalEditPart)this._part).getFigure();
            Rectangle rect = new Rectangle(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            figure.translateToAbsolute((Translatable)rect);
            return rect;
        }
        return null;
    }

    private FlowBox getClosestBox() {
        FlowBox closestBox = null;
        List fragments = this.getLines(this._part);
        int i = 0;
        while (i < fragments.size()) {
            Rectangle closestRect;
            int offset2;
            int offset1;
            FlowBox box = (FlowBox)fragments.get(i);
            Rectangle boxRect = this.getAbsoluteBounds(box);
            if (boxRect.contains(this._point.x, this._point.y)) {
                closestBox = box;
                break;
            }
            if (closestBox == null) {
                closestBox = box;
            } else {
                offset1 = Math.abs(CaretPositionResolver.getYDistance(boxRect, this._point));
                if (offset1 < (offset2 = Math.abs(CaretPositionResolver.getYDistance(closestRect = this.getAbsoluteBounds(closestBox), this._point)))) {
                    closestBox = box;
                }
            }
            if (closestBox != box && boxRect.contains(boxRect.x, this._point.y) && (offset1 = Math.abs(CaretPositionResolver.getXDistance(boxRect, this._point))) < (offset2 = Math.abs(CaretPositionResolver.getXDistance(closestRect = this.getAbsoluteBounds(closestBox), this._point)))) {
                closestBox = box;
            }
            ++i;
        }
        return closestBox;
    }

    public boolean contains(Point point) {
        return this.getAbsoluteBounds().contains(point);
    }

    public DesignPosition resolveTextPosition() {
        FlowBox flowBox;
        DesignPosition result = null;
        if (this._part instanceof TextEditPart && !EditModelQuery.isTransparentText(Target.resolveNode(this._part)) && (flowBox = this.getBox()) instanceof TextFragmentBox) {
            TextFragmentBox box = (TextFragmentBox)flowBox;
            if (((TextEditPart)this._part).getFigure() instanceof CSSTextFigure) {
                CSSTextFigure figure = (CSSTextFigure)((TextEditPart)this._part).getFigure();
                Rectangle boxRect = this.getAbsoluteBounds(box);
                int index = FlowUtilities.getTextInWidth(box.getTextData(), figure.getCSSStyle().getCSSFont().getSwtFont(), this._point.x - boxRect.x, TextLayoutSupport.getAverageCharWidth(box));
                result = new DesignPosition(this._part, box._offset + index);
            }
        }
        return result;
    }

    public DesignPosition resolvePosition(IPositionMediator validator) {
        DesignPosition result = this.resolveTextPosition();
        if (result == null) {
            boolean atPointLeft = this.isBeforePoint(this._point);
            Target target = new Target(this.getPart());
            if (validator.isValidPosition(new DOMRefPosition(target.getNode(), atPointLeft))) {
                result = new DesignRefPosition(this._part, atPointLeft);
            } else if (validator.isValidPosition(new DOMRefPosition(target.getNode(), !atPointLeft))) {
                result = new DesignRefPosition(this._part, !atPointLeft);
            } else if (validator.isEditable(target)) {
                result = atPointLeft ? new DesignPosition(this._part, 0) : new DesignPosition(this._part, this._part.getChildren().size());
            }
        }
        return result;
    }

    private boolean isAfterPoint(Point point) {
        Rectangle boxRect;
        boolean result = false;
        FlowBox flowBox = this.getLine(0);
        if ("br".equalsIgnoreCase(Target.resolveNode(this._part).getNodeName())) {
            if (flowBox != null) {
                Rectangle boxRect2 = this.getAbsoluteBounds(flowBox);
                result = CaretPositionResolver.getYDistance(boxRect2, point) == 0;
            }
        } else if (flowBox != null && CaretPositionResolver.getXDistance(boxRect = this.getAbsoluteBounds(flowBox), point) != 0) {
            result = CaretPositionResolver.getXDistance(boxRect, point) < 0 && CaretPositionResolver.getYDistance(boxRect, point) == 0;
        }
        return result |= this.isUnderCaret();
    }

    boolean isBeforePoint(Point point) {
        boolean result = false;
        FlowBox flowBox = this.getLastLine();
        if (flowBox != null) {
            Rectangle boxRect = this.getAbsoluteBounds(flowBox);
            if ("br".equalsIgnoreCase(Target.resolveNode(this._part).getNodeName())) {
                return CaretPositionResolver.getYDistance(boxRect, point) == 0;
            }
            if (CaretPositionResolver.getXDistance(boxRect, point) != 0) {
                result = CaretPositionResolver.getXDistance(boxRect, point) > 0 && CaretPositionResolver.getYDistance(boxRect, point) == 0;
            }
        }
        return result |= this.isAboveCaret();
    }

    boolean isBeforePoint() {
        return this.isBeforePoint(this._point);
    }

    boolean atLeftPart(Point point) {
        FlowBox flowBox = this.getBox();
        if (flowBox != null) {
            Rectangle boxRect = this.getAbsoluteBounds(flowBox);
            return CaretPositionResolver.toXMiddle(boxRect, point) < 0;
        }
        return true;
    }

    boolean isAfterPoint() {
        return this.isAfterPoint(this._point);
    }

    boolean atSameRow(Point point) {
        Rectangle bounds = this.getAbsoluteBounds();
        return bounds.contains(point.x, bounds.getRight().y);
    }

    static Rectangle getBounds(FlowBox box) {
        return new Rectangle(box.getX(), box.getY(), box.getWidth(), box.getHeight());
    }

    public Point getPoint() {
        return this._point;
    }

    FlowBox getLine(int index) {
        FlowBox result = null;
        List lines = this.getLines(this._part);
        if (lines.size() > 0 && index >= 0 && index <= lines.size() - 1) {
            result = (FlowBox)lines.get(index);
        }
        return result;
    }

    FlowBox getLastLine() {
        FlowBox result = null;
        List lines = this.getLines(this._part);
        if (lines.size() > 0) {
            result = (FlowBox)lines.get(lines.size() - 1);
        }
        return result;
    }

    List getLines(EditPart part) {
        List fragments = new ArrayList();
        if (part instanceof SubNodeEditPart) {
            IFigure figure = ((GraphicalEditPart)part).getFigure();
            if (figure instanceof CSSTextFigure) {
                fragments = ((CSSTextFigure)figure).getFragments();
                ((CSSTextFigure)figure).getCSSStyle();
            } else if (figure instanceof CSSFigure) {
                fragments = ((CSSFigure)figure).getFragmentsForRead();
                ((CSSFigure)figure).getCSSStyle();
            }
        }
        return fragments;
    }

    static EditPart getConcretePart(EditPart part) {
        if (part != null) {
            Node node = Target.resolveNode(part);
            Node child = node.getFirstChild();
            while (child != null) {
                EditPart result;
                if (!EditModelQuery.isTransparentText(child) && (result = Target.resolvePart(child)) != null) {
                    return result;
                }
                child = child.getNextSibling();
            }
        }
        return null;
    }

    public EditPart getConcretePart() {
        return LayoutPart.getConcretePart(this._part);
    }

    public static Node getConcreteNode(Node node) {
        if (node != null) {
            Node child = node.getFirstChild();
            while (child != null) {
                if (!EditModelQuery.isTransparentText(child)) {
                    return node;
                }
                child = child.getNextSibling();
            }
        }
        return null;
    }

    public boolean isCloseToEdgeFromOutSide() {
        boolean result = false;
        if (EditModelQuery.isBlockNode(Target.resolveNode(this._part))) {
            boolean bl = result = Math.abs(this.getAbsoluteBounds().getLeft().x - this._point.x) <= 10;
            if (!result) {
                result = Math.abs(this.getAbsoluteBounds().getRight().x - this._point.x) <= 10;
            }
        }
        return result;
    }

    private boolean isAboveCaret() {
        return this.getAbsoluteBounds().getBottom().y <= this._point.y;
    }

    private boolean isUnderCaret() {
        return this.getAbsoluteBounds().getTop().y >= this._point.y;
    }

    boolean isInline() {
        return EditModelQuery.isInline(Target.resolveNode(this._part));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("editPart:" + String.valueOf(this._part) + ", --- box: " + String.valueOf(this.getBox()));
        return sb.toString();
    }
}

