/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.internal.xml;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;

public class Resolver {
    private static final String PROP_START2 = "%{";
    private static final String PROP_END = "}";
    private static final String PROP_START = "${";
    private Map fPropertyValues = new HashMap();
    private ServerRuntime server;

    public Resolver(ServerRuntime runtime) {
        this.server = runtime;
    }

    public String resolveProperties(String proppedString) {
        HashMap<String, String> cache = new HashMap<String, String>(this.getProperties().size());
        for (Property element : this.getProperties()) {
            String value = element.getDefault();
            if (this.fPropertyValues != null && this.fPropertyValues.containsKey(element.getId())) {
                value = (String)this.fPropertyValues.get(element.getId());
            }
            if ("directory".equals(element.getType()) || "file".equals(element.getType())) {
                value = value.replace('\\', '/');
            }
            cache.put(element.getId(), value);
        }
        cache.put("pathChar", File.pathSeparator);
        String str = this.resolvePropertiesFromCache(proppedString, cache);
        str = this.fixPassthroughProperties(str);
        return str;
    }

    private List<Property> getProperties() {
        return this.server.getProperty();
    }

    private String fixPassthroughProperties(String str) {
        String resolvedString = str;
        if (this.isPassPropertyLeft(resolvedString)) {
            resolvedString = this.fixParam(resolvedString);
            resolvedString = this.fixPassthroughProperties(resolvedString);
        }
        return resolvedString;
    }

    private String resolvePropertiesFromCache(String proppedString, HashMap cache) {
        String resolvedString = proppedString;
        int start = this.skipToProperty(resolvedString, cache);
        if (start >= 0) {
            resolvedString = this.resolveProperty(resolvedString, cache);
            resolvedString = this.resolvePropertiesFromCache(resolvedString, cache);
        }
        return resolvedString;
    }

    private int skipToProperty(String str, HashMap cache) {
        if (str == null) {
            return -1;
        }
        int start = -1;
        int end = 0;
        String key = "";
        do {
            if ((start = str.indexOf(PROP_START, end)) >= 0) continue;
            return start;
        } while (!cache.containsKey(key = str.substring(start + 2, end = str.indexOf(PROP_END, start))) && VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable(key) == null);
        return start;
    }

    private boolean isPassPropertyLeft(String str) {
        return str.indexOf(PROP_START2) >= 0;
    }

    private String resolveProperty(String proppedString, HashMap cache) {
        IDynamicVariable dv;
        int end;
        StringBuffer str = new StringBuffer(proppedString);
        int start = str.indexOf(PROP_START);
        String key = str.substring(start + 2, end = str.indexOf(PROP_END, start));
        String value = (String)cache.get(key);
        if (value == null && (dv = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable(key)) != null) {
            try {
                value = dv.getValue(null);
            }
            catch (CoreException e) {
                CorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 1, "Can not resolve eclipse variable", (Throwable)e));
            }
        }
        if (value == null) {
            return str.toString();
        }
        return str.replace(start, end + 1, value).toString();
    }

    private String fixParam(String proppedString) {
        String str = proppedString;
        int start = str.indexOf(PROP_START2);
        return str.substring(0, start) + PROP_START + str.substring(start + 2);
    }

    public void setPropertyValues(Map propertyValues) {
        this.fPropertyValues = propertyValues;
    }
}

