/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal.xml.server40;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Engine;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Host;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Listener;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Service;
import org.eclipse.osgi.util.NLS;

public class ServerInstance {
    protected static final String DEFAULT_SERVICE = "Catalina";
    protected static final String DEFAULT_SERVICE2 = "Tomcat-Standalone";
    protected static final String DEFAULT_HOST = "localhost";
    protected Server server;
    protected Service service;
    protected Engine engine;
    protected Host host;
    protected String serviceName;
    protected String engineName;
    protected String hostName;
    protected String hostWorkDir;
    protected IStatus status = Status.OK_STATUS;

    public ServerInstance(Server server, String serviceName, String hostName) {
        if (server == null) {
            throw new IllegalArgumentException("Server argument may not be null.");
        }
        this.server = server;
        this.serviceName = serviceName;
        this.hostName = hostName;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public Listener[] getListeners() {
        this.status = Status.OK_STATUS;
        int size = this.server.getListenerCount();
        Listener[] listeners = new Listener[size];
        int i = 0;
        while (i < size) {
            listeners[i] = this.server.getListener(i);
            ++i;
        }
        return listeners;
    }

    public Service getService() {
        this.status = Status.OK_STATUS;
        if (this.service != null) {
            return this.service;
        }
        int serviceCount = this.server.getServiceCount();
        if (this.serviceName != null) {
            int i = 0;
            while (i < serviceCount) {
                Service svc = this.server.getService(i);
                if (this.serviceName.equalsIgnoreCase(svc.getName())) {
                    this.service = svc;
                    return this.service;
                }
                ++i;
            }
            this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLServiceNotFound, (Object)this.serviceName));
            return null;
        }
        if (serviceCount == 1) {
            this.service = this.server.getService(0);
            this.serviceName = this.service.getName();
            return this.service;
        }
        if (serviceCount > 1) {
            int i = 0;
            while (i < serviceCount) {
                Service svc = this.server.getService(i);
                String svcName = svc.getName();
                if (DEFAULT_SERVICE.equalsIgnoreCase(svc.getName())) {
                    this.service = svc;
                    this.serviceName = svcName;
                    return this.service;
                }
                if (DEFAULT_SERVICE2.equalsIgnoreCase(svc.getName())) {
                    this.service = svc;
                    this.serviceName = svcName;
                    return this.service;
                }
                ++i;
            }
            this.service = this.server.getService(0);
            this.serviceName = this.service.getName();
            return this.service;
        }
        this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", Messages.errorXMLNoService);
        return null;
    }

    public Connector getConnector(int index) {
        this.status = Status.OK_STATUS;
        if (this.service == null && this.getService() == null) {
            return null;
        }
        return this.service.getConnector(index);
    }

    public Connector[] getConnectors() {
        this.status = Status.OK_STATUS;
        if (this.service == null && this.getService() == null) {
            return null;
        }
        int size = this.service.getConnectorCount();
        Connector[] connectors = new Connector[size];
        int i = 0;
        while (i < size) {
            connectors[i] = this.service.getConnector(i);
            ++i;
        }
        return connectors;
    }

    public Engine getEngine() {
        this.status = Status.OK_STATUS;
        if (this.engine != null) {
            return this.engine;
        }
        if (this.service == null && this.getService() == null) {
            return null;
        }
        this.engine = this.service.getEngine();
        if (this.engine == null || this.engine.getName() == null) {
            this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLEngineNotFound, (Object)this.serviceName));
            return null;
        }
        this.engineName = this.engine.getName();
        if (this.hostName == null || this.hostName.length() == 0) {
            this.hostName = this.engine.getDefaultHost();
            if (this.hostName == null) {
                this.hostName = DEFAULT_HOST;
            }
        }
        return this.engine;
    }

    public Host getHost() {
        this.status = Status.OK_STATUS;
        if (this.host != null) {
            return this.host;
        }
        if (this.engine == null && this.getEngine() == null) {
            return null;
        }
        int size = this.engine.getHostCount();
        int i = 0;
        while (i < size) {
            Host h = this.engine.getHost(i);
            if (this.hostName.equals(h.getName())) {
                this.host = h;
                return this.host;
            }
            ++i;
        }
        this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLHostNotFound, (Object[])new String[]{this.hostName, this.engineName, this.serviceName}));
        return null;
    }

    public Context getContext(String contextPath) {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        if (contextPath != null && ((String)contextPath).length() > 0 && !((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        int size = this.host.getContextCount();
        int i = 0;
        while (i < size) {
            Context ctx = this.host.getContext(i);
            if (ctx.getPath().equals(contextPath)) {
                return ctx;
            }
            ++i;
        }
        this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLContextNotFoundPath, (Object[])new String[]{contextPath, this.serviceName, this.engineName, this.hostName}));
        return null;
    }

    public Context getContext(int index) {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        return this.host.getContext(index);
    }

    public Context[] getContexts() {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        int size = this.host.getContextCount();
        Context[] contexts = new Context[size];
        int i = 0;
        while (i < size) {
            contexts[i] = this.host.getContext(i);
            ++i;
        }
        return contexts;
    }

    public Context createContext(int index) {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        return (Context)this.host.createElement(index, "Context");
    }

    public boolean removeContext(String contextPath) {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return false;
        }
        if (contextPath != null && ((String)contextPath).length() > 0 && !((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        int size = this.host.getContextCount();
        int i = 0;
        while (i < size) {
            Context ctx = this.host.getContext(i);
            if (ctx.getPath().equals(contextPath)) {
                this.host.removeElement("Context", i);
                return true;
            }
            ++i;
        }
        this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLContextNotFoundPath, (Object[])new String[]{contextPath, this.serviceName, this.engineName, this.hostName}));
        return false;
    }

    public boolean removeContext(int index) {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return false;
        }
        return this.host.removeElement("Context", index);
    }

    public IPath getContextXmlDirectory(IPath confDir) {
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        return confDir.append(this.engineName).append(this.hostName);
    }

    public IPath getContextFilePath(IPath baseDir, Context context) {
        if (context == null) {
            throw new IllegalArgumentException(Messages.errorXMLNullContextArg);
        }
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        IPath contextFilePath = null;
        IPath contextDir = this.getContextXmlDirectory(baseDir.append("conf"));
        String name = context.getPath();
        if (name != null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (name.length() == 0) {
                name = "ROOT";
            }
            contextFilePath = contextDir.append(name + ".xml");
        }
        return contextFilePath;
    }

    public IPath getContextWorkDirectory(IPath basePath, Context context) {
        Path workPath;
        if (context == null) {
            throw new IllegalArgumentException(Messages.errorXMLNullContextArg);
        }
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        Object workDir = context.getAttributeValue("workDir");
        if (workDir == null) {
            String ctxName;
            if (this.hostWorkDir == null) {
                this.hostWorkDir = this.host.getAttributeValue("workDir");
                if (this.hostWorkDir == null || this.hostWorkDir.length() == 0) {
                    this.hostWorkDir = "work/" + this.engineName + "/" + this.hostName;
                }
            }
            if ((ctxName = context.getPath()).startsWith("/")) {
                ctxName = ctxName.substring(1);
            }
            ctxName = ctxName.replace('/', '_');
            if ((ctxName = ctxName.replace('\\', '_')).length() == 0) {
                ctxName = "_";
            }
            workDir = this.hostWorkDir + "/" + ctxName;
        }
        if (!(workPath = new Path((String)workDir)).isAbsolute()) {
            if (basePath == null) {
                basePath = new Path("");
            }
            workPath = basePath.append((IPath)workPath);
        }
        return workPath;
    }

    public IPath getHostWorkDirectory(IPath basePath) {
        Path workPath;
        this.status = Status.OK_STATUS;
        if (this.host == null && this.getHost() == null) {
            return null;
        }
        if (this.hostWorkDir == null) {
            this.hostWorkDir = this.host.getAttributeValue("workDir");
            if (this.hostWorkDir == null || this.hostWorkDir.length() == 0) {
                this.hostWorkDir = "work/" + this.engineName + "/" + this.hostName;
            }
        }
        if (!(workPath = new Path(this.hostWorkDir)).isAbsolute()) {
            if (basePath == null) {
                basePath = new Path("");
            }
            workPath = basePath.append((IPath)workPath);
        }
        return workPath;
    }
}

