/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.WsddFactoryImpl;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerDescriptionHelper;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerDescriptionHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ServiceHandlersWidgetOutputCommand
extends AbstractDataModelOperation {
    private WsddResource[] wsddResource_;
    private boolean isMultipleSelection_;
    private HandlerDescriptionHolder[] handlerDescriptionHolder_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        try {
            int i;
            if (this.isMultipleSelection_) {
                i = 0;
                while (i < this.handlerDescriptionHolder_.length) {
                    this.handlerDescriptionHolder_[i].addHandlerToAllPorts();
                    ++i;
                }
            } else {
                int h = 0;
                while (h < this.handlerDescriptionHolder_.length) {
                    Hashtable<String, PortComponent> wsPortsTable = new Hashtable<String, PortComponent>();
                    Hashtable wsPortToHandlerTable = new Hashtable();
                    String serviceDescName = this.handlerDescriptionHolder_[h].getDescriptionName();
                    HandlerDescriptionHolder hdh = HandlerDescriptionHelper.getForDescriptionName(this.handlerDescriptionHolder_, serviceDescName);
                    if (hdh != null) {
                        List handlerTableItems;
                        WebServiceDescription wsDescription_ = hdh.getDescriptionObject();
                        if (wsDescription_ != null) {
                            EList wsPorts = wsDescription_.getPortComponents();
                            int k = 0;
                            while (k < wsPorts.size()) {
                                PortComponent port = (PortComponent)wsPorts.get(k);
                                wsPortsTable.put(port.getPortComponentName(), port);
                                wsPortToHandlerTable.put(port.getPortComponentName(), new ArrayList());
                                ++k;
                            }
                        }
                        if ((handlerTableItems = hdh.getHandlerList()) != null) {
                            HandlerTableItem hti;
                            WsddFactoryImpl wsddFactory = new WsddFactoryImpl();
                            int i2 = 0;
                            while (i2 < handlerTableItems.size()) {
                                hti = (HandlerTableItem)handlerTableItems.get(i2);
                                PortComponent wsPort = hti.getPort();
                                if (wsPort == null) {
                                    if (wsPortsTable.get(hti.getPortName()) != null) {
                                        wsPort = (PortComponent)wsPortsTable.get(hti.getPortName());
                                    } else {
                                        wsPort = wsddFactory.createPortComponent();
                                        wsPort.setPortComponentName(hti.getPortName());
                                        wsPortsTable.put(wsPort.getPortComponentName(), wsPort);
                                    }
                                }
                                wsPortToHandlerTable.put(wsPort.getPortComponentName(), new ArrayList());
                                ++i2;
                            }
                            i2 = 0;
                            while (i2 < handlerTableItems.size()) {
                                Object handler;
                                hti = (HandlerTableItem)handlerTableItems.get(i2);
                                String portName = hti.getPortName();
                                PortComponent port = (PortComponent)wsPortsTable.get(portName);
                                if (port == null) {
                                    return status;
                                }
                                EList existingHandlers = port.getHandlers();
                                if (!existingHandlers.contains(handler = hti.getHandler())) {
                                    Handler newHandler = wsddFactory.createHandler();
                                    newHandler.setHandlerName(hti.getHandlerName());
                                    newHandler.setHandlerClass(hti.getHandlerClassName());
                                    ((List)wsPortToHandlerTable.get(portName)).add(newHandler);
                                } else if (handler instanceof Handler) {
                                    EtoolsCopyUtility copyUtil = new EtoolsCopyUtility();
                                    copyUtil.setCopyAdapters(true);
                                    Handler clonedHandler = (Handler)copyUtil.copy((EObject)((Handler)handler));
                                    ((List)wsPortToHandlerTable.get(portName)).add(clonedHandler);
                                }
                                ++i2;
                            }
                        }
                        this.removeExistingHandlers(wsPortsTable, wsPortToHandlerTable);
                        this.addPortsToDescriptions(wsPortsTable, wsDescription_);
                        this.addHandlersToPorts(wsPortsTable, wsPortToHandlerTable);
                    }
                    ++h;
                }
            }
            if (this.wsddResource_ != null) {
                i = 0;
                while (i < this.wsddResource_.length) {
                    if (this.wsddResource_[i] != null) {
                        this.wsddResource_[i].save(new HashMap());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private void removeExistingHandlers(Hashtable portsTable, Hashtable portsToHandlersTable) {
        try {
            Enumeration ports = portsToHandlersTable.keys();
            while (ports.hasMoreElements()) {
                String portName = (String)ports.nextElement();
                Object port = portsTable.get(portName);
                if (port == null || !(port instanceof PortComponent)) continue;
                EList handlers = ((PortComponent)port).getHandlers();
                handlers.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addPortsToDescriptions(Hashtable portsTable, WebServiceDescription wsDescription_) {
        try {
            Enumeration ports = portsTable.keys();
            while (ports.hasMoreElements()) {
                String portName = (String)ports.nextElement();
                Object port = portsTable.get(portName);
                EList emfPorts = wsDescription_.getPortComponents();
                if (emfPorts.contains(port) || port == null || !(port instanceof PortComponent)) continue;
                emfPorts.add((PortComponent)port);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addHandlersToPorts(Hashtable portsTable, Hashtable portsToHandlersTable) {
        try {
            Enumeration ports = portsToHandlersTable.keys();
            while (ports.hasMoreElements()) {
                String portName = (String)ports.nextElement();
                Object port = portsTable.get(portName);
                if (port == null || !(port instanceof PortComponent)) continue;
                List handlers = (List)portsToHandlersTable.get(portName);
                EList modelHandlers = ((PortComponent)port).getHandlers();
                modelHandlers.addAll(handlers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHandlerDescriptionHolders(HandlerDescriptionHolder[] hdhs) {
        this.handlerDescriptionHolder_ = hdhs;
    }

    public void setIsMultipleSelection(boolean isMulitpleSelection) {
        this.isMultipleSelection_ = isMulitpleSelection;
    }

    public void setWsddResource(WsddResource[] wsddRes) {
        this.wsddResource_ = wsddRes;
    }
}

