/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;

public class WebServiceWSDLLocationRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof ClassDeclaration)) continue;
            ClassDeclaration classDeclaration = (ClassDeclaration)declaration;
            this.checkWSDLocation(classDeclaration);
        }
    }

    private void checkWSDLocation(ClassDeclaration classDeclaration) {
        AnnotationMirror webService = AnnotationUtils.getAnnotation((Declaration)classDeclaration, WebService.class);
        AnnotationValue wsdlLocationValue = AnnotationUtils.getAnnotationValue((AnnotationMirror)webService, (String)"wsdlLocation");
        if (wsdlLocationValue != null) {
            String wsdlLocation = wsdlLocationValue.getValue().toString().trim();
            if (wsdlLocation.length() > 0) {
                if (!wsdlLocation.startsWith("file:/") && wsdlLocation.endsWith(".wsdl")) {
                    URL relativeURL = this.getRelativeURL(classDeclaration, wsdlLocation);
                    if (relativeURL != null) {
                        this.validateWSDL(relativeURL.toString(), webService, classDeclaration, wsdlLocationValue);
                    } else {
                        this.printWarning(wsdlLocationValue.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_UNABLE_TO_LOCATE, (Object)wsdlLocation));
                    }
                } else {
                    this.validateWSDL(wsdlLocation, webService, classDeclaration, wsdlLocationValue);
                }
            } else {
                this.printError(wsdlLocationValue.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.EMPTY_ATTRIBUTE_VALUE, (Object[])new Object[]{WebService.class.getSimpleName(), "wsdlLocation"}));
            }
        }
    }

    private URL getRelativeURL(ClassDeclaration classDeclaration, String wsdlLocation) {
        IResource wsdlResource;
        EclipseAnnotationProcessorEnvironment eclipseEnvironment;
        IJavaProject javaProject;
        IFolder webContentFolder;
        if (this.environment instanceof EclipseAnnotationProcessorEnvironment && (webContentFolder = WSDLUtils.getWebContentFolder((javaProject = (eclipseEnvironment = (EclipseAnnotationProcessorEnvironment)this.environment).getJavaProject()).getProject())) != null && (wsdlResource = webContentFolder.findMember(wsdlLocation)) != null) {
            try {
                return wsdlResource.getLocationURI().toURL();
            }
            catch (MalformedURLException murle) {
                JAXWSCorePlugin.log(murle);
            }
        }
        return null;
    }

    private void validateWSDL(String wsdlLocation, AnnotationMirror webService, ClassDeclaration classDeclaration, AnnotationValue wsdlLocationValue) {
        try {
            URL wsdlURL = new URL(wsdlLocation);
            Definition definition = WSDLUtils.readWSDL(wsdlURL);
            if (definition != null) {
                QName serviceQName = this.getServiceQName(webService, classDeclaration);
                Service service = this.getService(definition, serviceQName);
                if (service != null) {
                    String portName = this.getPortName(webService, classDeclaration);
                    Port port = this.getPort(service, portName);
                    if (port != null) {
                        Binding binding = port.getBinding();
                        this.validateBinding(binding, classDeclaration, webService, wsdlLocation);
                        Map<String, MethodDeclaration> methodMap = this.getWebMethods((TypeDeclaration)classDeclaration, webService);
                        List operations = binding.getPortType().getOperations();
                        for (Operation operation : operations) {
                            MethodDeclaration methodDeclaration = methodMap.get(operation.getName());
                            if (methodDeclaration == null) {
                                this.printError(webService.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_NO_OPERTATION_NAME, (Object)operation.getName()));
                                continue;
                            }
                            AnnotationMirror oneway = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, Oneway.class);
                            if (oneway == null || operation.getOutput() == null) continue;
                            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_WSDL_OPERATION_OUTPUT_METHOD_ONEWAY, (Object[])new Object[]{methodDeclaration.getSimpleName(), operation.getName()}));
                        }
                    } else {
                        this.printError(webService.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_NO_PORT_NAME, (Object[])new Object[]{portName, wsdlLocation}));
                    }
                } else {
                    this.printError(webService.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_NO_SERVICE_NAME, (Object[])new Object[]{serviceQName.getLocalPart(), wsdlLocation}));
                }
            } else {
                this.printWarning(wsdlLocationValue.getPosition(), this.getMessage(wsdlURL, wsdlLocation));
            }
        }
        catch (MalformedURLException murle) {
            this.printError(wsdlLocationValue.getPosition(), murle.getLocalizedMessage());
        }
        catch (IOException iOException) {
            this.printWarning(wsdlLocationValue.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_UNABLE_TO_LOCATE, (Object)wsdlLocation));
        }
    }

    private String getMessage(URL wsdlURL, String wsdlLocation) {
        String message = JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_UNABLE_TO_LOCATE, (Object)wsdlLocation);
        try {
            File file;
            URI uri = wsdlURL.toURI();
            if (uri.getScheme().equals("file") && (file = new File(uri)).exists()) {
                message = JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_UNABLE_TO_READ, (Object)wsdlLocation);
            }
        }
        catch (URISyntaxException urise) {
            JAXWSCorePlugin.log(urise);
        }
        return message;
    }

    private void validateBinding(Binding binding, ClassDeclaration classDeclaration, AnnotationMirror webService, String wsdlLocation) {
        String styleValue;
        String style = SOAPBinding.Style.DOCUMENT.name();
        AnnotationMirror soapBindingAnnotation = this.getSOAPBinding((TypeDeclaration)classDeclaration, webService);
        if (soapBindingAnnotation != null && (styleValue = AnnotationUtils.getStringValue((AnnotationMirror)soapBindingAnnotation, (String)"style")) != null) {
            style = styleValue;
        }
        List extensibilityElements = binding.getExtensibilityElements();
        for (Object elementExtensible : extensibilityElements) {
            SOAP12Binding soap12Binding;
            SOAPBinding soapBinding;
            if (elementExtensible instanceof SOAPBinding && (soapBinding = (SOAPBinding)elementExtensible).getStyle() != null && style.compareToIgnoreCase(soapBinding.getStyle()) != 0) {
                this.printError(soapBindingAnnotation == null ? webService.getPosition() : soapBindingAnnotation.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_SOAP_BINDING_STYLE, (Object[])new Object[]{wsdlLocation, soapBinding.getStyle(), style}));
            }
            if (!(elementExtensible instanceof SOAP12Binding) || (soap12Binding = (SOAP12Binding)elementExtensible).getStyle() == null || style.compareToIgnoreCase(soap12Binding.getStyle()) == 0) continue;
            this.printError(soapBindingAnnotation == null ? webService.getPosition() : soapBindingAnnotation.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_WSDL_LOCATION_SOAP_BINDING_STYLE, (Object[])new Object[]{wsdlLocation, soap12Binding.getStyle(), style}));
        }
    }

    private AnnotationMirror getSOAPBinding(TypeDeclaration typeDeclaration, AnnotationMirror webService) {
        TypeDeclaration seiDeclaration;
        String endpointInterface = AnnotationUtils.getStringValue((AnnotationMirror)webService, (String)"endpointInterface");
        if (endpointInterface != null && (seiDeclaration = this.environment.getTypeDeclaration(endpointInterface)) != null) {
            typeDeclaration = seiDeclaration;
        }
        return AnnotationUtils.getAnnotation((Declaration)typeDeclaration, javax.jws.soap.SOAPBinding.class);
    }

    private Map<String, MethodDeclaration> getWebMethods(TypeDeclaration typeDeclaration, AnnotationMirror webService) {
        TypeDeclaration seiDeclaration;
        HashMap<String, MethodDeclaration> methodMap = new HashMap<String, MethodDeclaration>();
        String endpointInterface = AnnotationUtils.getStringValue((AnnotationMirror)webService, (String)"endpointInterface");
        if (endpointInterface != null && (seiDeclaration = this.environment.getTypeDeclaration(endpointInterface)) != null) {
            typeDeclaration = seiDeclaration;
        }
        Collection methods = typeDeclaration.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            AnnotationMirror webMethod = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, WebMethod.class);
            if (webMethod != null && !this.isExluded(webMethod)) {
                methodMap.put(this.getOperationName(webMethod, methodDeclaration), methodDeclaration);
                continue;
            }
            methodMap.put(methodDeclaration.getSimpleName(), methodDeclaration);
        }
        return methodMap;
    }

    private boolean isExluded(AnnotationMirror webMethod) {
        Boolean exclude = AnnotationUtils.getBooleanValue((AnnotationMirror)webMethod, (String)"exclude");
        if (exclude != null) {
            return exclude;
        }
        return false;
    }

    private String getOperationName(AnnotationMirror webMethod, MethodDeclaration methodDeclaration) {
        String operationName = AnnotationUtils.getStringValue((AnnotationMirror)webMethod, (String)"operationName");
        if (operationName != null) {
            return operationName;
        }
        return methodDeclaration.getSimpleName();
    }

    private Service getService(Definition definition, QName serviceQName) {
        Map servicesMap = definition.getServices();
        Set servicesSet = servicesMap.entrySet();
        for (Map.Entry serviceEntry : servicesSet) {
            QName serviceEntryKey = (QName)serviceEntry.getKey();
            if (!serviceEntryKey.equals(serviceQName)) continue;
            return (Service)serviceEntry.getValue();
        }
        return null;
    }

    private Port getPort(Service service, String portName) {
        Map portsMap = service.getPorts();
        Set portsSet = portsMap.entrySet();
        for (Map.Entry portEntry : portsSet) {
            String portEntryKey = (String)portEntry.getKey();
            if (!portEntryKey.equals(portName)) continue;
            return (Port)portEntry.getValue();
        }
        return null;
    }

    private QName getServiceQName(AnnotationMirror webService, ClassDeclaration classDeclaration) {
        String serviceName = AnnotationUtils.getStringValue((AnnotationMirror)webService, (String)"serviceName");
        if (serviceName == null) {
            serviceName = String.valueOf(classDeclaration.getSimpleName()) + "Service";
        }
        return new QName(this.getTargetNamespace(webService, classDeclaration), serviceName);
    }

    private String getPortName(AnnotationMirror webService, ClassDeclaration classDeclaration) {
        String portName = AnnotationUtils.getStringValue((AnnotationMirror)webService, (String)"portName");
        if (portName == null) {
            portName = String.valueOf(classDeclaration.getSimpleName()) + "Port";
        }
        return portName;
    }

    private String getTargetNamespace(AnnotationMirror webService, ClassDeclaration classDeclaration) {
        String targetNamespace = AnnotationUtils.getStringValue((AnnotationMirror)webService, (String)"targetNamespace");
        if (targetNamespace == null) {
            targetNamespace = JDTUtils.getTargetNamespaceFromPackageName(classDeclaration.getPackage().getQualifiedName());
        }
        return targetNamespace;
    }
}

