/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.Messages;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.PerfVersion;
import org.eclipse.linuxtools.internal.perf.model.PMCommand;
import org.eclipse.linuxtools.internal.perf.model.PMDso;
import org.eclipse.linuxtools.internal.perf.model.PMEvent;
import org.eclipse.linuxtools.internal.perf.model.PMFile;
import org.eclipse.linuxtools.internal.perf.model.PMSymbol;
import org.eclipse.linuxtools.internal.perf.model.TreeParent;
import org.eclipse.linuxtools.internal.perf.ui.PerfProfileView;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PerfCore {
    private static Map<String, Map<String, List<String>>> eventsHostMap = null;
    private static Map<String, List<String>> eventList = null;

    private static String spitStream(BufferedReader br, String blockTitle, PrintStream print) {
        StringBuilder strBuf = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                strBuf.append(line);
                strBuf.append("\n");
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        String str = strBuf.toString();
        if (!str.trim().isEmpty() && print != null) {
            print.println(blockTitle + ": \n" + str + "\n END OF " + blockTitle);
        }
        return str;
    }

    public static Map<String, List<String>> getEventList(ILaunchConfiguration config) {
        String projectHost = PerfCore.getHostName(config);
        if (eventsHostMap == null) {
            eventsHostMap = new HashMap<String, Map<String, List<String>>>();
        }
        if (projectHost == null) {
            projectHost = "local";
        }
        if ((eventList = eventsHostMap.get(projectHost)) == null) {
            eventList = PerfCore.loadEventList(config);
            eventsHostMap.put(projectHost, eventList);
        }
        return eventList;
    }

    private static String getHostName(ILaunchConfiguration config) {
        String projectName = null;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException e) {
            return null;
        }
        if (projectName.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        URI projectURI = project.getLocationURI();
        if (projectURI == null) {
            IStatus status = Status.warning((String)NLS.bind((String)Messages.MsgNoProjectError, (Object)projectName));
            PerfPlugin.getDefault().getLog().log(status);
            return null;
        }
        return project.getLocationURI().getHost();
    }

    public static IProject getProject(ILaunchConfiguration config) {
        if (config == null) {
            return null;
        }
        try {
            String projectName = ConfigUtils.getProjectName((ILaunchConfiguration)config);
            if (projectName != null && !projectName.isEmpty()) {
                return ConfigUtils.getProject((String)projectName);
            }
        }
        catch (CoreException e1) {
            PerfCore.logException((Exception)((Object)e1));
        }
        return null;
    }

    private static Map<String, List<String>> loadEventList(ILaunchConfiguration config) {
        HashMap<String, List<String>> events = new HashMap<String, List<String>>();
        IProject project = PerfCore.getProject(config);
        if (!PerfCore.checkPerfInPath(project)) {
            return events;
        }
        Process p = null;
        BufferedReader input = null;
        try {
            p = RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "list"}, project);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        return PerfCore.parseEventList(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> parseEventList(BufferedReader input) {
        HashMap<String, List<String>> events = new HashMap<String, List<String>>();
        try {
            String line;
            while ((line = input.readLine()) != null) {
                String event;
                String category;
                if (!line.matches("\\s*\\S+\\s*\\[.*\\]")) continue;
                if (line.contains("Hardware breakpoint")) {
                    category = "Hardware breakpoint";
                    event = line.substring(1, line.indexOf(91, 0)).trim();
                } else if (line.contains("Raw hardware event descriptor")) {
                    category = "Raw hardware event descriptor";
                    event = line.substring(1, line.indexOf(91, 0)).trim();
                } else {
                    event = line.substring(1, line.indexOf(91, 0)).trim();
                    if (event.contains("OR")) {
                        event = event.split("OR")[0];
                    }
                    category = line.replaceFirst(".*\\[(.+)\\]", "$1").trim();
                }
                ArrayList<String> categoryEvents = (ArrayList<String>)events.get(category);
                if (categoryEvents == null) {
                    categoryEvents = new ArrayList<String>();
                    events.put(category, categoryEvents);
                }
                categoryEvents.add(event.trim());
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return events;
    }

    public static PerfVersion getPerfVersion(ILaunchConfiguration config) {
        Pattern pattern;
        Matcher matcher;
        IProject project = PerfCore.getProject(config);
        Process p = null;
        try {
            p = RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "--version"}, project);
        }
        catch (IOException e) {
            PerfPlugin.getDefault().getLog().log((IStatus)Status.warning((String)e.getMessage(), (Throwable)e));
        }
        if (p == null) {
            return null;
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String perfVersion = PerfCore.spitStream(input, "Perf --version", null);
        int index = perfVersion.indexOf(45);
        if (index > 0) {
            perfVersion = perfVersion.substring(0, index);
        }
        if ((matcher = (pattern = Pattern.compile("\\D*((\\d|\\.)+)")).matcher(perfVersion)).matches()) {
            return new PerfVersion(matcher.group(1));
        }
        return null;
    }

    public static boolean checkPerfInPath(IProject project) {
        try {
            Process p = RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "--version"}, project);
            return p != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String[] getRecordString(ILaunchConfiguration config) {
        String[] base = new String[]{"perf", "record"};
        if (config == null) {
            return base;
        }
        ArrayList<String> newCommand = new ArrayList<String>();
        newCommand.addAll(Arrays.asList(base));
        try {
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime", false)) {
                newCommand.add("-r");
                int priority = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime.Priority", 1);
                newCommand.add(Integer.toString(priority));
            }
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Verbose", false)) {
                newCommand.add("-v");
            }
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Multiplex", false)) {
                newCommand.add("-M");
            }
            List selE = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
            if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true) && selE != null) {
                for (Object e : selE) {
                    newCommand.add("-e");
                    newCommand.add((String)e);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return newCommand.toArray(new String[0]);
    }

    public static String[] getReportString(ILaunchConfiguration config, String perfDataLoc) {
        ArrayList<String> base = new ArrayList<String>();
        base.addAll(Arrays.asList("perf", "report", "--sort", "comm,dso,sym", "-n", "-t", "\u0001"));
        if (config != null) {
            try {
                String kernelLoc = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
                if (!kernelLoc.equals("")) {
                    base.add("--vmlinux");
                    base.add(kernelLoc);
                }
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false)) {
                    base.add("-m");
                }
                if (perfDataLoc != null) {
                    base.add("-i");
                    base.add(perfDataLoc);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return base.toArray(new String[base.size()]);
    }

    public static String[] getAnnotateString(ILaunchConfiguration config, String dso, String symbol, String perfDataLoc, boolean oldPerfVersion) {
        ArrayList<String> base = new ArrayList<String>();
        if (oldPerfVersion) {
            base.addAll(Arrays.asList("perf", "annotate", "-s", symbol, "-l", "-P"));
        } else {
            base.addAll(Arrays.asList("perf", "annotate", "--stdio", "-d", dso, "-s", symbol, "-l", "-P"));
        }
        if (config != null) {
            try {
                String kernelLoc = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
                if (!kernelLoc.equals("")) {
                    base.add("--vmlinux");
                    base.add(kernelLoc);
                }
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false)) {
                    base.add("-m");
                }
                if (perfDataLoc != null) {
                    base.add("-i");
                    base.add(perfDataLoc);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        base.add("<");
        base.add("/dev/null");
        return base.toArray(new String[base.size()]);
    }

    public static void report(ILaunchConfiguration config, IPath workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print) {
        IProject project = PerfCore.getProject(config);
        TreeParent invisibleRoot = PerfPlugin.getDefault().clearModelRoot();
        PerfVersion perfVersion = PerfCore.getPerfVersion(config);
        boolean oldPerfVersion = false;
        if (perfVersion == null) {
            if (print != null) {
                print.println("ERROR: Unable to find Perf version, please verify it is installed and on the run path");
                return;
            }
        } else if (!perfVersion.isNewer(new PerfVersion(0, 0, 2))) {
            oldPerfVersion = true;
            if (print != null) {
                print.println("WARNING: You are running an older version of Perf, please update if you can. The plugin may produce unpredictable results.");
            }
        }
        BufferedReader input = null;
        BufferedReader error = null;
        Process p = null;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            if (workingDir == null) {
                p = RuntimeProcessFactory.getFactory().exec(PerfCore.getReportString(config, perfDataLoc), project);
                PerfPlugin.getDefault().setPerfProfileData((IPath)new Path(perfDataLoc));
                PerfPlugin.getDefault().setWorkingDir(project.getLocation());
            } else {
                String defaultPerfDataLoc = workingDir.toOSString() + "perf.data";
                p = RuntimeProcessFactory.getFactory().exec(PerfCore.getReportString(config, defaultPerfDataLoc), project);
                PerfPlugin.getDefault().setPerfProfileData((IPath)new Path(defaultPerfDataLoc));
                PerfPlugin.getDefault().setWorkingDir(workingDir);
            }
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        PerfCore.parseRemoteReport(config, workingDir, monitor, perfDataLoc, print, invisibleRoot, oldPerfVersion, input, error, project);
    }

    public static void parseReport(ILaunchConfiguration config, IPath workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print, TreeParent invisibleRoot, boolean oldPerfVersion, BufferedReader input, BufferedReader error) {
        PerfCore.parseRemoteReport(config, workingDir, monitor, perfDataLoc, print, invisibleRoot, oldPerfVersion, input, error, null);
    }

    private static void parseRemoteReport(ILaunchConfiguration config, IPath workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print, TreeParent invisibleRoot, boolean oldPerfVersion, BufferedReader input, BufferedReader error, IProject project) {
        boolean hasProfileData;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        String line = null;
        Process p = null;
        PMEvent currentEvent = null;
        TreeParent currentCommand = null;
        TreeParent currentDso = null;
        PMFile currentFile = null;
        PMSymbol currentSym = null;
        try {
            while ((line = input.readLine()) != null) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                if (line.startsWith("#")) {
                    if (line.contains("Events:") || line.contains("Samples:")) {
                        if (line.startsWith("# Total Lost Samples:")) continue;
                        String[] tmp = line.trim().split(" ");
                        String event = tmp[tmp.length - 1];
                        if (line.contains("Samples:")) {
                            event = event.substring(1, event.length() - 1);
                        }
                        currentEvent = new PMEvent(event);
                        invisibleRoot.addChild(currentEvent);
                        currentCommand = null;
                        currentDso = null;
                        continue;
                    }
                    if (!line.contains("Samples:")) continue;
                    if (print != null) {
                        print.println("WARNING: You are running an older version of Perf, please update if you can. The plugin may produce unpredictable results.");
                    }
                    invisibleRoot.addChild(new PMEvent("WARNING: You are running an older version of Perf, the plugin may produce unpredictable results."));
                    continue;
                }
                String[] items = line.trim().split("\u0001");
                if (items.length != 5) continue;
                float percent = Float.parseFloat(items[0].replace("%", ""));
                double samples = Double.parseDouble(items[1].trim());
                String comm = items[2].trim();
                String dso = items[3].trim();
                String symbol = items[4].trim();
                boolean kernelFlag = ("" + symbol.charAt(1)).equals("k");
                if (!(currentCommand != null && currentCommand.getName().equals(comm) || (currentCommand = (PMCommand)currentEvent.getChild(comm)) != null)) {
                    currentCommand = new PMCommand(comm);
                    currentEvent.addChild(currentCommand);
                }
                if (!(currentDso != null && currentDso.getName().equals(dso) || (currentDso = (PMDso)currentCommand.getChild(dso)) != null)) {
                    currentDso = new PMDso(dso, kernelFlag);
                    currentCommand.addChild(currentDso);
                }
                currentFile = ((PMDso)currentDso).getFile("Unfiled Symbols");
                currentSym = new PMSymbol(symbol, percent, samples);
                currentFile.addChild(currentSym);
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        PerfCore.spitStream(error, "Perf Report", print);
        boolean SourceLineNumbers = true;
        boolean Kernel_SourceLineNumbers = false;
        try {
            SourceLineNumbers = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers", true);
            Kernel_SourceLineNumbers = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers", false);
        }
        catch (CoreException e2) {
            SourceLineNumbers = false;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        boolean bl = hasProfileData = invisibleRoot.getChildren().length != 0;
        if (SourceLineNumbers) {
            for (TreeParent ev : invisibleRoot.getChildren()) {
                if (!(ev instanceof PMEvent)) continue;
                for (TreeParent cmd : ev.getChildren()) {
                    if (!(cmd instanceof PMCommand)) continue;
                    for (TreeParent d : cmd.getChildren()) {
                        if (!(d instanceof PMDso)) continue;
                        currentDso = (PMDso)d;
                        if (!Kernel_SourceLineNumbers && ((PMDso)currentDso).isKernelDso()) continue;
                        for (TreeParent s : ((PMDso)currentDso).getFile("Unfiled Symbols").getChildren()) {
                            String[] annotateCmd;
                            if (!(s instanceof PMSymbol)) continue;
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            currentSym = (PMSymbol)s;
                            if (workingDir == null) {
                                annotateCmd = PerfCore.getAnnotateString(config, currentDso.getName(), currentSym.getName().substring(4), perfDataLoc, oldPerfVersion);
                            } else {
                                String perfDefaultDataLoc = String.valueOf(workingDir) + "/perf.data";
                                annotateCmd = PerfCore.getAnnotateString(config, currentDso.getName(), currentSym.getName().substring(4), perfDefaultDataLoc, oldPerfVersion);
                            }
                            try {
                                if (project == null) {
                                    p = Runtime.getRuntime().exec(annotateCmd);
                                } else {
                                    StringBuilder sb = new StringBuilder();
                                    ArrayList<String> al = new ArrayList<String>();
                                    al.add("sh");
                                    al.add("-c");
                                    if (workingDir != null) {
                                        sb.append("cd " + workingDir.toOSString() + " && ");
                                    }
                                    for (int i = 0; i < annotateCmd.length; ++i) {
                                        sb.append(annotateCmd[i]);
                                        sb.append(" ");
                                    }
                                    al.add(sb.toString());
                                    p = RuntimeProcessFactory.getFactory().exec(al.toArray(new String[0]), project);
                                }
                                input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                            }
                            catch (IOException e) {
                                PerfCore.logException(e);
                            }
                            PerfCore.parseAnnotation(monitor, input, workingDir, (PMDso)currentDso, currentSym);
                        }
                        if (((PMDso)currentDso).getFile("Unfiled Symbols").getChildren().length == 0) {
                            currentDso.removeChild(((PMDso)currentDso).getFile("Unfiled Symbols"));
                        }
                        PerfCore.spitStream(error, "Perf Annotate", print);
                    }
                }
            }
        }
        if (print != null) {
            if (hasProfileData) {
                print.println("Profile data loaded into Perf Profile View.");
            } else {
                print.println("No profile data generated to be displayed.");
            }
        }
    }

    public static void parseAnnotation(IProgressMonitor monitor, BufferedReader input, IPath workingDir, PMDso currentDso, PMSymbol currentSym) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        boolean grabBlock = false;
        boolean blockStarted = false;
        String line = null;
        try {
            while ((line = input.readLine()) != null) {
                String[] items;
                if (line.startsWith("Sorted summary for file")) {
                    grabBlock = true;
                    Object dsoName = line.replace("Sorted summary for file ", "");
                    blockStarted = false;
                    if (workingDir != null && ((String)dsoName).startsWith("./")) {
                        dsoName = workingDir.toOSString().endsWith("/") ? workingDir.toOSString() + ((String)dsoName).substring(2) : workingDir.toOSString() + ((String)dsoName).substring(1);
                    }
                    currentDso.setPath((String)dsoName);
                    continue;
                }
                if (line.startsWith("---")) {
                    if (blockStarted) {
                        blockStarted = false;
                        grabBlock = false;
                        continue;
                    }
                    blockStarted = true;
                    continue;
                }
                if (!grabBlock || !blockStarted || (items = line.trim().split(" +")).length != 2) continue;
                float percent = Float.parseFloat(items[0]);
                String lineRef = items[1];
                items = lineRef.split(":");
                if (currentDso == null) break;
                int lineNum = -1;
                try {
                    if (items.length > 1) {
                        lineNum = Integer.parseInt(items[1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                currentSym.addPercent(lineNum, Float.valueOf(percent));
                if (currentSym.getParent().getName().equals("Unfiled Symbols")) {
                    currentSym.getParent().removeChild(currentSym);
                    currentDso.getFile(items[0]).addChild(currentSym);
                    continue;
                }
                if (((PMFile)currentSym.getParent()).getPath().equals(items[0])) continue;
                currentSym.markConflict();
                currentSym.getParent().removeChild(currentSym);
                currentDso.getFile("Symbols conflicting in multiple files").addChild(currentSym);
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
    }

    public static void refreshView(String title) {
        Display.getDefault().syncExec(() -> {
            try {
                PerfProfileView view = (PerfProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.ProfileView");
                view.setContentDescription(title);
                view.refreshModel();
            }
            catch (PartInitException e) {
                PerfCore.logException((Exception)((Object)e));
            }
        });
    }

    public static void logException(Exception e) {
        IStatus status = Status.error((String)e.getMessage(), (Throwable)e);
        PerfPlugin.getDefault().getLog().log(status);
    }
}

