/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.launch.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PerfEventsTab
extends AbstractLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    protected Button chkDefaultEvent;
    protected TabItem[] eventTabItems;
    protected Table[] eventTable;
    protected TabFolder tabFolder;
    private int rawTabIndex = 0;
    private int bpTabIndex = 0;
    protected Text rawText;
    protected Text bpText;
    private Composite top;
    private IProject previousProject = null;

    public Image getImage() {
        return PerfPlugin.getImageDescriptor("icons/event.gif").createImage();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.top = top;
    }

    private void createEventTabs(Composite top, ILaunchConfiguration config) {
        Map<String, List<String>> events = PerfCore.getEventList(config);
        ArrayList<String> tmpTabNames = new ArrayList<String>(events.keySet());
        List<String> SPECIAL_EVENTS = Arrays.asList("Hardware breakpoint", "Raw hardware event descriptor");
        tmpTabNames.removeAll(SPECIAL_EVENTS);
        tmpTabNames.addAll(SPECIAL_EVENTS);
        String[] tabNames = tmpTabNames.toArray(new String[0]);
        this.eventTabItems = new TabItem[tabNames.length];
        this.eventTable = new Table[tabNames.length];
        this.tabFolder = new TabFolder(top, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < tabNames.length; ++i) {
            Table table;
            this.eventTabItems[i] = new TabItem(this.tabFolder, 0);
            this.eventTabItems[i].setText(tabNames[i]);
            if (tabNames[i].equals("Hardware breakpoint") || tabNames[i].equals("Raw hardware event descriptor")) {
                Table table2;
                Composite c = new Composite((Composite)this.tabFolder, 0);
                c.setLayout((Layout)new GridLayout(2, false));
                this.eventTable[i] = table2 = new Table(c, 34);
                table2.setLayoutData((Object)new GridData(4, 4, true, true));
                table2.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
                Composite right = new Composite(c, 0);
                right.setLayout((Layout)new GridLayout(2, false));
                right.setLayoutData((Object)new GridData(131072, 4, false, true));
                Label l = new Label(right, 0);
                l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                Text t = new Text(right, 2052);
                t.setLayoutData((Object)new GridData(4, 128, true, false));
                if (tabNames[i].equals("Hardware breakpoint")) {
                    this.bpTabIndex = i;
                    this.bpText = t;
                    l.setText(Messages.PerfEventsTab_HardwareBreakpoint);
                }
                if (tabNames[i].equals("Raw hardware event descriptor")) {
                    this.rawTabIndex = i;
                    this.rawText = t;
                    l.setText(Messages.PerfEventsTab_RawRegisterEncoding);
                }
                Button b = new Button(right, 8);
                b.setText(Messages.PerfEventsTab_Add);
                b.setLayoutData((Object)new GridData(131072, 128, false, false));
                b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    int index = this.tabFolder.getSelectionIndex();
                    if (this.rawTabIndex == index) {
                        new TableItem(this.eventTable[index], 0).setText(this.rawText.getText());
                    } else if (this.bpTabIndex == index) {
                        new TableItem(this.eventTable[index], 0).setText(this.bpText.getText());
                    }
                    this.updateLaunchConfigurationDialog();
                }));
                l = new Label(right, 0);
                l.setForeground(new Color((Device)right.getDisplay(), 100, 100, 100));
                if (tabNames[i].equals("Hardware breakpoint")) {
                    l.setText(Messages.PerfEventsTab_ForExample);
                }
                if (tabNames[i].equals("Raw hardware event descriptor")) {
                    l.setText(Messages.PerfEventsTab_ForExampleR1A8);
                }
                l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                l = new Label(right, 0);
                l.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                b = new Button(right, 8);
                b.setText(Messages.PerfEventsTab_RemoveSelectedEvents);
                b.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    this.eventTable[this.tabFolder.getSelectionIndex()].remove(this.eventTable[this.tabFolder.getSelectionIndex()].getSelectionIndices());
                    this.updateLaunchConfigurationDialog();
                }));
                l = new Label(right, 0);
                l.setForeground(new Color((Device)right.getDisplay(), 100, 100, 100));
                l.setText(Messages.PerfEventsTab_Note);
                l.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                this.eventTabItems[i].setControl((Control)c);
                continue;
            }
            this.eventTable[i] = table = new Table((Composite)this.tabFolder, 32);
            List<String> eventList = events.get(tabNames[i]);
            for (String event : eventList) {
                TableItem item = new TableItem(table, 0);
                item.setText(event);
            }
            table.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
            this.eventTabItems[i].setControl((Control)table);
        }
    }

    private void refreshDefaultEnabled() {
        boolean state = !this.chkDefaultEvent.getSelection();
        for (Table tab : this.eventTable) {
            tab.setEnabled(state);
        }
    }

    public String getName() {
        return Messages.PerfEventsTab_Events;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        IProject project = this.getProject(config);
        try {
            List selectedEvents;
            List rawhe;
            if (this.previousProject == null || this.previousProject != null && !this.previousProject.equals((Object)project)) {
                Control[] children;
                for (Control control : children = this.top.getChildren()) {
                    control.dispose();
                }
                this.createVerticalSpacer(this.top, 1);
                this.chkDefaultEvent = new Button(this.top, 32);
                this.chkDefaultEvent.setText("Default Event");
                this.chkDefaultEvent.setLayoutData((Object)new GridData());
                this.chkDefaultEvent.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    this.refreshDefaultEnabled();
                    this.updateLaunchConfigurationDialog();
                }));
                this.createEventTabs(this.top, config);
            }
            this.chkDefaultEvent.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true));
            this.refreshDefaultEnabled();
            List hwbps = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
            if (hwbps != null) {
                for (int i = 0; i < this.eventTable.length; ++i) {
                    if (!this.eventTabItems[i].getText().equals("Hardware breakpoint")) continue;
                    this.eventTable[i].removeAll();
                    for (Object e2 : hwbps) {
                        TableItem x = new TableItem(this.eventTable[i], 0);
                        x.setText((String)e2);
                    }
                }
            }
            if ((rawhe = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default)) != null) {
                for (int i = 0; i < this.eventTable.length; ++i) {
                    if (!this.eventTabItems[i].getText().equals("Raw hardware event descriptor")) continue;
                    this.eventTable[i].removeAll();
                    for (Object e3 : rawhe) {
                        TableItem x = new TableItem(this.eventTable[i], 0);
                        x.setText((String)e3);
                    }
                }
            }
            if ((selectedEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default)) != null) {
                for (int i = 0; i < this.eventTable.length; ++i) {
                    for (TableItem event : this.eventTable[i].getItems()) {
                        if (selectedEvents.contains(event.getText())) {
                            event.setChecked(true);
                            continue;
                        }
                        event.setChecked(false);
                    }
                }
            }
            this.previousProject = project;
        }
        catch (CoreException e4) {
            e4.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", this.chkDefaultEvent.getSelection());
        ArrayList<String> selectedEvents = new ArrayList<String>();
        for (int i = 0; i < this.eventTable.length; ++i) {
            for (TableItem x : this.eventTable[i].getItems()) {
                if (!x.getChecked()) continue;
                selectedEvents.add(x.getText());
            }
        }
        if (selectedEvents.size() == 0) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", (String)null);
        } else {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", selectedEvents);
        }
        if (!this.chkDefaultEvent.getSelection() && !selectedEvents.isEmpty()) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", true);
        } else {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", false);
        }
        if (selectedEvents.size() <= 0) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true);
        }
        ArrayList<String> hwbps = new ArrayList<String>();
        for (int i = 0; i < this.eventTable.length; ++i) {
            if (!this.eventTabItems[i].getText().equals("Hardware breakpoint")) continue;
            for (TableItem x : this.eventTable[i].getItems()) {
                hwbps.add(x.getText());
            }
        }
        if (hwbps.size() == 0) {
            hwbps = null;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", hwbps);
        ArrayList<String> rawhwe = new ArrayList<String>();
        for (int i = 0; i < this.eventTable.length; ++i) {
            if (!this.eventTabItems[i].getText().equals("Raw hardware event descriptor")) continue;
            for (TableItem x : this.eventTable[i].getItems()) {
                rawhwe.add(x.getText());
            }
        }
        if (rawhwe.size() == 0) {
            rawhwe = null;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", rawhwe);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default);
    }

    private IProject getProject(ILaunchConfiguration config) {
        String name = null;
        try {
            name = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        }
        catch (CoreException e) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }
}

