/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.NewProjectCreationPage;
import org.eclipse.linuxtools.rpm.core.RPMProjectCreator;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RPMNewProject
extends Wizard
implements INewWizard {
    private NewProjectCreationPage namePage;

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    RPMNewProject.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException | InvocationTargetException x) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.addPages();
        this.namePage = new NewProjectCreationPage(Messages.getString("RPMNewProject.0"));
        this.namePage.setTitle(Messages.getString("RPMNewProject.1"));
        this.namePage.setDescription(Messages.getString("RPMNewProject.2"));
        this.namePage.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/rpm.gif"));
        this.addPage((IWizardPage)this.namePage);
        this.namePage.init(selection);
    }

    protected void createProject(IProgressMonitor monitor) throws CoreException {
        RPMProjectCreator rpmProjectCreator = new RPMProjectCreator(this.namePage.getSelectedLayout());
        IProject project = rpmProjectCreator.create(this.namePage.getProjectName(), this.namePage.getLocationPath(), monitor);
        IWorkingSet[] workingSets = this.namePage.getWorkingSets();
        if (workingSets.length > 0) {
            PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
        }
    }
}

