/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts;

import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.ChartWithAxisMouseMoveListener;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;

public abstract class AbstractChartWithAxisBuilder
extends AbstractChartBuilder {
    private PaintListener titleBoundsPaintListener;
    private double defaultMargin = 0.04;
    protected boolean xLineGrid = this.store.getBoolean("ShowXGridLines");
    protected boolean yLineGrid = this.store.getBoolean("ShowYGridLines");
    protected int xSeriesTicks = this.store.getInt("XSeriesTicks");
    protected int ySeriesTicks = this.store.getInt("YSeriesTicks");

    protected double getChartMarginXL() {
        return this.defaultMargin;
    }

    protected double getChartMarginXU() {
        return this.defaultMargin;
    }

    protected double getChartMarginYL() {
        return this.defaultMargin;
    }

    protected double getChartMarginYU() {
        return this.defaultMargin;
    }

    protected abstract ISeries createChartISeries(int var1);

    @Override
    protected void updateProperties(PropertyChangeEvent event) {
        super.updateProperties(event);
        String eventName = event.getProperty();
        if (eventName.equals("ShowXGridLines")) {
            this.xLineGrid = this.store.getBoolean("ShowXGridLines");
            this.buildXAxis();
        } else if (eventName.equals("ShowYGridLines")) {
            this.yLineGrid = this.store.getBoolean("ShowYGridLines");
            this.buildYAxis();
        } else if (eventName.equals("XSeriesTicks")) {
            this.xSeriesTicks = this.store.getInt("XSeriesTicks");
            this.buildXAxis();
        } else if (eventName.equals("YSeriesTicks")) {
            this.ySeriesTicks = this.store.getInt("YSeriesTicks");
            this.buildYAxis();
        }
    }

    public AbstractChartWithAxisBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(adapter, parent, style, title);
    }

    @Override
    protected void createChart() {
        super.createChart();
        this.applyTitleBoundsListener();
        this.chartMouseMoveListener = new ChartWithAxisMouseMoveListener((Chart)this.chart, this.chart.getPlotArea().getControl());
    }

    protected void applyTitleBoundsListener() {
        ITitle title = this.chart.getTitle();
        if (title instanceof Control) {
            this.titleBoundsPaintListener = e -> {
                Rectangle bounds = this.chart.getPlotArea().getBounds();
                Control title1 = (Control)this.chart.getTitle();
                Rectangle titleBounds = title1.getBounds();
                title1.setLocation(new Point(bounds.x + (bounds.width - titleBounds.width) / 2, title1.getLocation().y));
            };
            this.chart.addPaintListener(this.titleBoundsPaintListener);
        } else {
            this.chart.removePaintListener((PaintListener)title);
            this.titleBoundsPaintListener = e -> {
                ITitle title1 = this.chart.getTitle();
                Font font = title1.getFont();
                Font oldFont = e.gc.getFont();
                e.gc.setFont(font);
                Control legend = (Control)this.chart.getLegend();
                Rectangle legendBounds = legend.getBounds();
                int adjustment = legendBounds.width - 15;
                Point blankSize = e.gc.textExtent(" ");
                int numBlanks = adjustment / blankSize.x >> 1 << 1;
                Object text = title1.getText().trim();
                for (int i = 0; i < numBlanks; ++i) {
                    text = (String)text + " ";
                }
                e.gc.setFont(oldFont);
                title1.setText((String)text);
            };
            this.chart.addPaintListener(this.titleBoundsPaintListener);
            this.chart.addPaintListener((PaintListener)title);
        }
    }

    protected void removeTitleBoundsListener() {
        if (this.titleBoundsPaintListener != null) {
            this.chart.removePaintListener(this.titleBoundsPaintListener);
            this.titleBoundsPaintListener = null;
        }
    }

    @Override
    protected void buildXAxis() {
        String[] labels = this.adapter.getLabels();
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        if (this.xLineGrid) {
            xAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            xAxis.getGrid().setStyle(LineStyle.NONE);
        }
        xAxis.getTick().setForeground(BLACK);
        xAxis.getTick().setTickMarkStepHint(this.xSeriesTicks);
        ITitle xTitle = xAxis.getTitle();
        xTitle.setForeground(BLACK);
        if (labels.length > 0) {
            xTitle.setText(labels[0]);
        } else {
            xTitle.setText("");
        }
    }

    @Override
    protected void buildYAxis() {
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText("");
        if (this.yLineGrid) {
            yAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            yAxis.getGrid().setStyle(LineStyle.NONE);
        }
        yAxis.getTick().setForeground(BLACK);
        yAxis.getTick().setTickMarkStepHint(this.ySeriesTicks);
    }

    @Override
    protected void buildXSeries() {
        double minX;
        double maxX;
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        int leny = data[0].length - 1;
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        Double[] all_valx = new Double[len];
        Double[][] all_valy = new Double[leny][len];
        double maxY = maxX = Double.NEGATIVE_INFINITY;
        double minY = minX = Double.POSITIVE_INFINITY;
        block0: for (int i = 0; i < len; ++i) {
            for (int j = 0; j < leny + 1; ++j) {
                Double val = this.getDoubleOrNullValue(data[start + i][j]);
                if (j == 0) {
                    if (val == null) continue block0;
                    all_valx[i] = val;
                    maxX = Math.max(val, maxX);
                    minX = Math.min(val, minX);
                    continue;
                }
                if (val == null) continue;
                all_valy[j - 1][i] = val;
                maxY = Math.max(val, maxY);
                minY = Math.min(val, minY);
            }
        }
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        ISeries series = null;
        for (int i = 0; i < leny; ++i) {
            series = i >= allSeries.length ? this.createChartISeries(i) : this.chart.getSeriesSet().getSeries()[i];
            double[] valx = new double[len];
            double[] valy = new double[len];
            int len_trim = 0;
            for (int j = 0; j < len; ++j) {
                if (all_valx[j] == null || all_valy[i][j] == null) continue;
                valx[len_trim] = all_valx[j];
                valy[len_trim] = all_valy[i][j];
                ++len_trim;
            }
            double[] valx_trim = new double[len_trim];
            double[] valy_trim = new double[len_trim];
            for (int j = 0; j < len_trim; ++j) {
                valx_trim[j] = valx[j];
                valy_trim[j] = valy[j];
            }
            series.setXSeries(valx_trim);
            series.setYSeries(valy_trim);
        }
        if (series != null && series.getXSeries().length > 0) {
            this.applyRangeX(minX, maxX);
            this.applyRangeY(minY, maxY);
        }
        this.chart.redraw();
    }

    private void applyRangeX(double min, double max) {
        IAxis axis = this.chart.getAxisSet().getXAxis(0);
        double actualRange = max - min;
        double scaledRange = actualRange * this.scale;
        double marginL = scaledRange > 0.0 ? scaledRange * this.getChartMarginXL() : 1.0;
        double marginU = scaledRange > 0.0 ? scaledRange * this.getChartMarginXU() : 1.0;
        double lower = (actualRange - scaledRange) * this.scroll + min;
        axis.setRange(new Range(lower - marginL, lower + scaledRange + marginU));
    }

    protected void applyRangeY(double min, double max) {
        IAxis axis = this.chart.getAxisSet().getYAxis(0);
        double actualRange = max - min;
        double scaledRange = actualRange * this.scaleY;
        double marginL = scaledRange > 0.0 ? scaledRange * this.getChartMarginYL() : 1.0;
        double marginU = scaledRange > 0.0 ? scaledRange * this.getChartMarginYU() : 1.0;
        double lower = (actualRange - scaledRange) * this.scrollY + min;
        axis.setRange(new Range(lower - marginL, lower + scaledRange + marginU));
    }

    @Override
    public void updateDataSet() {
        this.buildXSeries();
        this.chartMouseMoveListener.update();
    }

    @Override
    protected void buildYSeries() {
    }
}

