/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.widgets;

import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.Messages;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;

public class GraphDiscreteXControl
extends Composite
implements IUpdateListener {
    private static final double ZOOM_AMOUNT = 2.0;
    private AbstractChartBuilder builder;
    private Button zoomInButton;
    private Button zoomOutButton;
    private Button allButton;
    private Button leftButton;
    private Button rightButton;
    private Button firstButton;
    private Button lastButton;

    public GraphDiscreteXControl(GraphComposite comp, int style) {
        super((Composite)comp, style);
        this.builder = comp.getCanvas();
        this.setLayout((Layout)new RowLayout());
        Font font = new Font((Device)comp.getDisplay(), "Arial", 10, 1);
        FormData thisData = new FormData();
        thisData.bottom = new FormAttachment(100, 0);
        thisData.left = new FormAttachment((Control)this.builder, 0, 16384);
        this.setLayoutData(thisData);
        this.firstButton = new Button((Composite)this, 0x1000000);
        this.firstButton.setText(Messages.GraphDiscreteXControl_First);
        this.firstButton.setFont(font);
        this.firstButton.setEnabled(false);
        this.firstButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.builder.setScroll(0.0);
            this.firstButton.setEnabled(false);
            this.leftButton.setEnabled(false);
            this.rightButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        }));
        this.leftButton = new Button((Composite)this, 0x1000000);
        this.leftButton.setText(Messages.GraphDiscreteXControl_Left);
        this.leftButton.setFont(font);
        this.leftButton.setEnabled(false);
        this.leftButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.stepScroll(-1)));
        this.zoomInButton = new Button((Composite)this, 0x1000000);
        this.zoomInButton.setText(Messages.GraphDiscreteXControl_ZoomIn);
        this.zoomInButton.setFont(font);
        this.zoomInButton.setEnabled(false);
        this.zoomInButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.builder.setScale(this.builder.getScale() / 2.0)));
        this.zoomOutButton = new Button((Composite)this, 0x1000000);
        this.zoomOutButton.setText(Messages.GraphDiscreteXControl_ZoomOut);
        this.zoomOutButton.setFont(font);
        this.zoomOutButton.setEnabled(false);
        this.zoomOutButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.builder.setScale(this.builder.getScale() * 2.0)));
        this.allButton = new Button((Composite)this, 0x1000000);
        this.allButton.setText(Messages.GraphDiscreteXControl_All);
        this.allButton.setFont(font);
        this.allButton.setEnabled(false);
        this.allButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.builder.setScale(1.0)));
        this.rightButton = new Button((Composite)this, 0x1000000);
        this.rightButton.setText(Messages.GraphDiscreteXControl_Right);
        this.rightButton.setFont(font);
        this.rightButton.setEnabled(false);
        this.rightButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.stepScroll(1)));
        this.lastButton = new Button((Composite)this, 0x1000000);
        this.lastButton.setText(Messages.GraphDiscreteXControl_Last);
        this.lastButton.setFont(font);
        this.lastButton.setEnabled(false);
        this.lastButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.builder.setScroll(1.0);
            this.firstButton.setEnabled(true);
            this.leftButton.setEnabled(true);
            this.rightButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        }));
    }

    private int getNumItems() {
        ISeries[] series = this.builder.getChart().getSeriesSet().getSeries();
        return series.length > 0 ? series[0].getXSeries().length : 0;
    }

    private void stepScroll(int step) {
        this.builder.setScroll(this.builder.getScroll() + (double)step / (double)this.getNumItems() / (1.0 - this.builder.getScale()));
    }

    public void handleUpdateEvent() {
        IAxis xAxis = this.builder.getChart().getAxisSet().getXAxis(0);
        Range range = xAxis.getRange();
        this.zoomInButton.setEnabled(range.upper - range.lower > 0.0);
        boolean showingAll = this.builder.getScale() == 1.0;
        this.zoomOutButton.setEnabled(!showingAll);
        this.allButton.setEnabled(!showingAll);
        boolean hitLeft = showingAll || range.lower == 0.0;
        boolean hitRight = showingAll || range.upper == (double)(this.getNumItems() - 1);
        this.leftButton.setEnabled(!hitLeft);
        this.rightButton.setEnabled(!hitRight);
        this.firstButton.setEnabled(!hitLeft);
        this.lastButton.setEnabled(!hitRight);
    }
}

