/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.consolelog;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.linuxtools.internal.systemtap.consolelog.FileHyperlink;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ErrorLineMatcher
implements IPatternMatchListenerDelegate {
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            String line = this.console.getDocument().get(event.getOffset(), event.getLength());
            String file = line.substring(line.indexOf(47));
            String[] splitted = file.split(":");
            Path path = new Path(splitted[0]);
            if (path.toFile().exists()) {
                IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)path);
                FileHyperlink fileLink = new FileHyperlink(iFileStore, Integer.valueOf(splitted[1]));
                this.console.addHyperlink((IHyperlink)fileLink, line.indexOf(47) + event.getOffset(), file.length());
            }
        }
        catch (BadLocationException e1) {
            return;
        }
    }
}

