/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.tools.launch.core.factory.CdtSpawnerProcessFactory;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class ValgrindCommand {
    protected static final String WHICH_CMD = "which";
    protected static final String VALGRIND_CMD = "valgrind";
    protected Process process;
    protected String[] args;

    public String getValgrindCommand() {
        return VALGRIND_CMD;
    }

    public String whichVersion(IProject project) throws IOException {
        Process p = RuntimeProcessFactory.getFactory().exec(new String[]{this.getValgrindCommand(), "--version"}, project);
        try {
            StringBuilder out = new StringBuilder();
            this.readIntoBuffer(out, p);
            return out.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void execute(String[] commandArray, String[] env, File wd, boolean usePty, IProject project) throws IOException {
        this.args = commandArray;
        try {
            this.process = this.startProcess(commandArray, env, wd, usePty, project);
        }
        catch (IOException e) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw e;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getCommandLine() {
        StringBuilder ret = new StringBuilder();
        for (String arg : this.args) {
            ret.append(arg).append(" ");
        }
        return ret.toString().trim();
    }

    private Process startProcess(String[] commandArray, String[] env, File workDir, boolean usePty, IProject project) throws IOException {
        if (workDir == null) {
            return CdtSpawnerProcessFactory.getFactory().exec(commandArray, env, project);
        }
        if (PTY.isSupported((PTY.Mode)PTY.Mode.CONSOLE) && usePty) {
            return CdtSpawnerProcessFactory.getFactory().exec(commandArray, env, workDir, new PTY(), project);
        }
        return CdtSpawnerProcessFactory.getFactory().exec(commandArray, env, workDir, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIntoBuffer(StringBuilder out, Process p) throws IOException {
        if (p == null) {
            throw new IOException("Null Process object: unabled to read input into buffer");
        }
        try (InputStream err = p.getErrorStream();
             InputStream input = p.getInputStream();){
            int ch;
            boolean success = p.waitFor() == 0;
            InputStream in = success ? input : err;
            while ((ch = in.read()) != -1) {
                out.append((char)ch);
            }
            if (!success) {
                throw new IOException(out.toString());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            p.getOutputStream().close();
        }
    }
}

