/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.views.build.ContainerNode;
import org.eclipse.m2e.core.ui.internal.views.build.MojoExecutionNode;

class ProjectNode
extends ContainerNode {
    private final Map<MojoExecutionKey, MojoExecutionNode> executions = new HashMap<MojoExecutionKey, MojoExecutionNode>();
    private final AtomicInteger buildCount = new AtomicInteger();

    public ProjectNode(String name) {
        super(name);
    }

    public int incrementBuildCount() {
        return this.buildCount.incrementAndGet();
    }

    @Override
    public int getBuildCount() {
        return this.buildCount.get();
    }

    public synchronized MojoExecutionNode getMojoExecutionNode(MojoExecutionKey mojoExecutionKey) {
        MojoExecutionNode node = this.executions.get(mojoExecutionKey);
        if (node == null) {
            node = new MojoExecutionNode(mojoExecutionKey);
            this.executions.put(mojoExecutionKey, node);
        }
        return node;
    }

    public synchronized Collection<MojoExecutionNode> getMojoExecutions() {
        return new ArrayList<MojoExecutionNode>(this.executions.values());
    }
}

