/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateLifecycleMappingMetadataException;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.configurator.AbstractLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class LifecycleMappingResult {
    private LifecycleMappingMetadata lifecycleMappingMetadata;
    private Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping;
    private final List<MavenProblemInfo> problems = new ArrayList<MavenProblemInfo>();
    private AbstractLifecycleMapping lifecycleMapping;
    private Map<String, AbstractProjectConfigurator> configurators;

    public String getLifecycleMappingId() {
        if (this.lifecycleMapping != null) {
            return this.lifecycleMapping.getId();
        }
        if (this.lifecycleMappingMetadata != null) {
            return this.lifecycleMappingMetadata.getLifecycleMappingId();
        }
        return null;
    }

    public LifecycleMappingMetadata getLifecycleMappingMetadata() {
        return this.lifecycleMappingMetadata;
    }

    public Map<MojoExecutionKey, List<IPluginExecutionMetadata>> getMojoExecutionMapping() {
        return this.mojoExecutionMapping;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    public List<MavenProblemInfo> getProblems() {
        return this.problems;
    }

    public void setLifecycleMappingMetadata(LifecycleMappingMetadata lifecycleMappingMetadata) {
        this.lifecycleMappingMetadata = lifecycleMappingMetadata;
    }

    public void setMojoExecutionMapping(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping) {
        this.mojoExecutionMapping = mojoExecutionMapping;
    }

    public void addProblem(MavenProblemInfo problem) {
        this.problems.add(problem);
    }

    public void setLifecycleMapping(AbstractLifecycleMapping lifecycleMapping) {
        this.lifecycleMapping = lifecycleMapping;
    }

    public AbstractLifecycleMapping getLifecycleMapping() {
        if (this.getProblems().stream().anyMatch(p -> p.getError() instanceof DuplicateLifecycleMappingMetadataException)) {
            return null;
        }
        return this.lifecycleMapping;
    }

    public Map<String, AbstractProjectConfigurator> getProjectConfigurators() {
        return this.configurators;
    }

    public void setProjectConfigurators(Map<String, AbstractProjectConfigurator> configurators) {
        this.configurators = configurators;
    }
}

