/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.m2e.internal.launch.MavenLaunchDelegate;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class MavenJRETab
extends JavaJRETab {
    private final VMArgumentsBlock vmArgumentsBlock = new VMArgumentsBlock();

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.fJREBlock.getControl();
        ((GridData)comp.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)comp.getLayoutData()).verticalAlignment = 4;
        this.vmArgumentsBlock.createControl(comp);
        ((GridData)this.vmArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    protected IJavaProject getJavaProject() {
        File pomDir = MavenLaunchDelegate.getPomDirectory(this.getLaunchConfiguration());
        return MavenLaunchDelegate.getContainer(pomDir).map(IResource::getProject).filter(IResource::exists).map(JavaCore::create).filter(IJavaElement::exists).orElse(null);
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        File pomDirectory = MavenLaunchDelegate.getPomDirectory(this.getLaunchConfiguration());
        String version = MavenLaunchDelegate.readEnforcedJavaVersion(pomDirectory, null);
        IVMInstall mavenJre = version != null ? MavenLaunchDelegate.getBestMatchingVM(version) : null;
        final String details = mavenJre != null ? NLS.bind((String)Messages.MavenJRETab_lblDefaultDetailsRequiredJavaVersion, (Object)mavenJre.getName(), (Object)version) : super.getDefaultJREDescriptor().getDescription();
        return new JREDescriptor(){

            public String getDescription() {
                return NLS.bind((String)Messages.MavenJRETab_lblDefault, (Object)details);
            }
        };
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IStatus status = this.fJREBlock.getStatus();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.vmArgumentsBlock.performApply(configuration);
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.vmArgumentsBlock.initializeFrom(configuration);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.vmArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

